/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

#include <Graphics/Common/Shader/hkgShaderDefines.h>

class hkgPostEffect;

#include <Graphics/Managed/Math/hkgMathCLR.h>
#include <Graphics/Managed/DisplayContext/hkgDisplayContextCLR.h>

using namespace System::IO;
using namespace System;
using namespace System::Collections::Generic;

namespace Havok {
namespace Graphics {

	public ref class hkgPostEffectCLR
	{
	public:

		hkgPostEffectCLR(hkgDisplayContextCLR^ ctx);
		~hkgPostEffectCLR();

		String^ getDefaultFileNameExtension();
	
		bool realizeFromFile( String^ path );
		bool realize(Stream^ stream);
		
		void free();	

		void setName(String^ name );
		String^ getName();

		int  getNumFloatInputs( );
		String^ getFloatInputName( int i );
		int getFloatInputSize( int i );
		
		void setFloatInputByName( String^ n, float v );
		void setFloatInputByName( String^ n, hkgVector3CLR v );
		void setFloatInputByName( String^ n, hkgVector4CLR v);
		void setFloatInputByName( String^ n, hkgMatrix4CLR m, int rows); // rows normal 3 or 4 (for 12 or 16 entry xfrom)
			
	internal:
		
		hkgPostEffectCLR(hkgPostEffect* toWrap);
		hkgPostEffect* m_effect;
	};

} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
