/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

struct hkgViewportPickData;
struct hkgDisplayObjectPickData;
struct hkgGeometryPickData;
struct hkgFaceSetPickData;
class hkgRay;

#include <Graphics/Managed/Math/hkgMathCLR.h>

namespace Havok {
namespace Graphics {

	ref class hkgDisplayWorldCLR;

	public ref class hkgRayCLR
	{
	public:

		hkgRayCLR();
		hkgRayCLR(hkgVector3CLR from, hkgVector3CLR dir);
		~hkgRayCLR();
		
		hkgVector3CLR getFrom();
		hkgVector3CLR getDir();

		void transform( hkgMatrix4CLR t );

		void getPosAtDist( hkgVector3CLR% pos, float dist );

		bool triangleIntersect(hkgVector3CLR v0, hkgVector3CLR v1, hkgVector3CLR v2, float &t, float &u, float &v);
		bool hitsSphere( hkgVector3CLR pos, float radius);

	internal:

		hkgRay* m_ray;
	};



	public ref class hkgFaceSetPickDataCLR
	{
	public:

		hkgFaceSetPickDataCLR();
		~hkgFaceSetPickDataCLR();

		float getDist(); 
		int getPrimIndex(); 
		int getPrimTriIndex(); 
		void getVertexIndices( int% v0, int% v1, int% v2); 
		int	getMatFaceSetIndex();		
		int getMatFaceSetSubIndex();

	internal:

		hkgFaceSetPickDataCLR(hkgFaceSetPickData* toWrap);
		hkgFaceSetPickData* m_data;
		bool m_ownData;
	};

	public ref class hkgGeometryPickDataCLR
	{
	public:

		hkgGeometryPickDataCLR();
		~hkgGeometryPickDataCLR();

		int getNumFacePickDatas();
		hkgFaceSetPickDataCLR^ getFacePickData(int idx);
		hkgVector3CLR getLocalPos();
		int getGeomIndex();

	internal:
		hkgGeometryPickDataCLR(hkgGeometryPickData* toWrap);
		hkgGeometryPickData* m_data;
		bool m_ownData;
	};

	public ref class hkgDisplayObjectPickDataCLR
	{
	public:

		hkgDisplayObjectPickDataCLR();
		~hkgDisplayObjectPickDataCLR();

		int getNumGeomPickDatas();
		hkgGeometryPickDataCLR^ getGeomPickData(int idx);
		int	getObjectIndex();
		hkgVector3CLR getWorldPos();
		hkgVector3CLR getWorldNormal();

	internal:

		hkgDisplayObjectPickDataCLR(hkgDisplayObjectPickData* toWrap);
		hkgDisplayObjectPickData* m_data;
		bool m_ownData;
	};

	public ref class hkgViewportPickDataCLR
	{
	public:

		hkgViewportPickDataCLR();
		~hkgViewportPickDataCLR();

		int getNumObjectPickDatas();
		hkgDisplayObjectPickDataCLR^ getObjectPickData(int idx);
		hkgDisplayWorldCLR^ getWorld();
		int getNumTrianglesHit();

		// convenience functions
		float getClosestDistance();
		int getClosestObjectIndex();
		hkgVector3CLR getClosestObjectWorldPos();
		hkgVector3CLR getClosestObjectWorldNormal();
		int getClosestGeometryIndex();
		hkgVector3CLR getClosestGeometryLocalPos();

	internal:

		hkgViewportPickData* m_data;
	};


} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
