/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */



#pragma once

#include <Common/Base/Types/hkBaseTypes.h>

# if defined(HK_REAL_IS_DOUBLE)
	class hkVector4d;
	typedef hkVector4d hkVector4;
	class hkQuaterniond;
	typedef hkQuaterniond hkQuaternion;
#else
	class hkVector4f;
	typedef hkVector4f hkVector4;
	class hkQuaternionf;
	typedef hkQuaternionf hkQuaternion;
# endif

class hkgAabb;

namespace Havok {
namespace Graphics {

	const int HKG_X = 0;
	const int HKG_Y = 1;
	const int HKG_Z = 2;
	
	public ref class hkgMath
	{
	public:
		
		static float DegreesToRadians = (3.14159265358979f / 180.0f);
		static float RadiansToDegrees = (180.0f / 3.14159265358979f);
	};	
	
	value struct hkgMatrix4CLR;

	[System::Reflection::DefaultMemberAttribute("Item")]
	public value struct hkgVector3CLR
	{
	public:

		void set(float x, float y, float z);
		void setZero();
		void setOne();
		void set( const ::hkVector4& other );
		void get( ::hkVector4& other );

		float len();
		float lenSqrd();
		float normalize();
		void mult( float scale );
		void sub( hkgVector3CLR a );
		void add( hkgVector3CLR a );
		void setMult( hkgVector3CLR a, float scale ); 
		void setSub( hkgVector3CLR a, hkgVector3CLR b); 
		void setAdd( hkgVector3CLR a, hkgVector3CLR b); 
		bool equals( hkgVector3CLR a, float tolerance);
		void setCross( hkgVector3CLR a, hkgVector3CLR b); // out != a or b
		float dot( hkgVector3CLR a);
		bool isOk();

		void rotate( hkgMatrix4CLR r );
		void transform( hkgMatrix4CLR t );
		void transformNormal( hkgMatrix4CLR t );

		void setInterpolate( hkgVector3CLR a, hkgVector3CLR b, float t);

		int getMajorAxis();
		
			/// Computes two vectors, bOut and cOut, that are orthogonal to aIn and each other.
		static void computePerpendicularVectors( hkgVector3CLR aIn, hkgVector3CLR% bOut, hkgVector3CLR% cOut );

		System::Drawing::Color toColor();
		void fromColor(System::Drawing::Color c);

		property float Item [int]
		{
			float get(int index) { return index < 1? X : (index < 2? Y : Z); }
			void set(int index, float val) { if (index < 1) X = val; else { if (index < 2) Y = val; else Z = val; } }
		}

		float X; 
		float Y; 
		float Z; 
	};

	[System::Reflection::DefaultMemberAttribute("Item")]
	public value struct hkgVector4CLR
	{
	public: 

		void set(float x, float y, float z, float w);
		void setZero();
		void setOne();

		void mult( float s );
		void transform( hkgMatrix4CLR t ); 

		System::Drawing::Color toColor();
		void fromColor(System::Drawing::Color c);

		bool equals(hkgVector4CLR other, float tol);

		property float Item [int]
		{
			float get(int i) { return i < 1? X : (i < 2? Y : ( i < 3? Z : W )); }
			void set(int i, float val) { if (i < 1) X = val; else { if (i < 2) Y = val; else if (i < 3) Z = val; else W = val; } }
		}

		float X;
		float Y;
		float Z;
		float W;
	};

	public value struct hkgMatrix4CLR
	{

	public: 

		void set( float _m00, float _m10, float _m20, float _m30,
			float _m01, float _m11, float _m21, float _m31,
			float _m02, float _m12, float _m22, float _m32,		
			float _m03, float _m13, float _m23, float _m33 );

		void set(hkgVector4CLR c0, hkgVector4CLR c1, hkgVector4CLR c2, hkgVector4CLR c3);

		void setIdentity();

		void setTranspose(hkgMatrix4CLR a);
		void setMult( hkgMatrix4CLR a, hkgMatrix4CLR b); // a after b 		
		void setQuickInvert( hkgMatrix4CLR m );  // no scale etc
		bool setInvert( hkgMatrix4CLR m , float epsilon); //= 0.001f

		hkgVector3CLR getTranslation();
		void setTranslation(hkgVector3CLR translation);
		
		static hkgMatrix4CLR buildRotation( hkgVector3CLR axis, float angle );

			// RC (Row Column), translation = [m03,m13,m23]
		float m00;
		float m10;
		float m20;
		float m30;
		float m01;
		float m11;
		float m21;
		float m31;
		float m02;
		float m12;
		float m22;
		float m32;
		float m03;
		float m13;
		float m23;
		float m33;
	};

	public value struct hkgQuaternionCLR
	{
	public:
				
		void set(float x, float y, float z, float w);
		void setIdentity();
		void setAxisAngle(hkgVector3CLR axis, float angle);
		void set( const ::hkQuaternion& other );
		void get( ::hkQuaternion& other );
						
		float getAngle();
		
		float X;
		float Y;
		float Z;
		float W;
	};
	
	public value struct hkgQsTransformCLR
	{
	public:		
		
		void setIdentity();
		
		hkgVector4CLR m_translation;
		hkgQuaternionCLR m_rotation;
		hkgVector4CLR m_scale;		
	};
	
	public ref class hkgAabbCLR
	{
	public:

		// Allowed create aabbs
		hkgAabbCLR();
		hkgAabbCLR(hkgVector3CLR pmin, hkgVector3CLR pmax);

		~hkgAabbCLR();

		hkgVector3CLR getMin();
		hkgVector3CLR getMax();
		
		void addPoint( hkgVector3CLR p );
		void transform( hkgMatrix4CLR t );
		hkgVector3CLR getPoint(int i);
		hkgVector3CLR getCentroid();
		bool rayIntersect(hkgVector3CLR start, hkgVector3CLR dir, float& t );
		float getVolume();
		void reset();

	internal:

		hkgAabb* m_aabb;
	};
	
} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
