/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

class hkgMaterialManager;
class hkgMaterial;

#include <Graphics/Managed/Math/hkgMathCLR.h>
#include <Graphics/Managed/DisplayContext/hkgDisplayContextCLR.h>

#include <Graphics/Common/Material/hkgMaterialDefines.h>

namespace Havok {
namespace Graphics {

	ref class hkgMaterialManagerCLR;
	ref class hkgShaderEffectCollectionCLR;
	ref class hkgTextureCLR;
	ref class hkgVertexSetCLR;

	public ref class hkgMaterialCLR
	{
	public:

		enum struct TransSource
		{
			COLOR = HKG_MATERIAL_TRANS_SOURCE_COLOR, 
			TEXTURE = HKG_MATERIAL_TRANS_SOURCE_TEXTURE,
			BOTH = HKG_MATERIAL_TRANS_SOURCE_BOTH   
		};

		hkgMaterialCLR();
		~hkgMaterialCLR();

		void setTexture(int i, hkgTextureCLR^ t); 
		void addTexture(hkgTextureCLR^ t); 
		hkgTextureCLR^ getTexture(int stage);

		hkgDisplayContextCLR::TextureMode getTextureMode(int stage);
		void setTextureMode( int stage, hkgDisplayContextCLR::TextureMode m );

		void setShaderCollection(hkgShaderEffectCollectionCLR^ s); 
		hkgShaderEffectCollectionCLR^ getShaderCollection();

		void setDiffuseColor( hkgVector4CLR c );
		void getDiffuseColor( hkgVector4CLR% c );
		
		void setSpecularColor( hkgVector3CLR c );
		void getSpecularColor( hkgVector3CLR% c );

		void setSpecularPower( float p );
		float getSpecularPower();

		IntPtr getUserData();
		void setUserData(IntPtr t);

		void realizeTextures();

		void bind(hkgDisplayContextCLR^ context, hkgVertexSetCLR^ vhints ); 
		void unbind(hkgDisplayContextCLR^ context); 
	
		bool isTransparent();
		TransSource getTransparentSource() ;

		bool isDefaultMaterial();

	internal:

		hkgMaterialCLR(hkgMaterial* toWrap);
		hkgMaterial* m_material;
	};
	
} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
