/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

#include <Graphics/Common/Light/hkgLightDefines.h>

class hkgLight;
class hkgLightManager;

#include <Graphics/Managed/Math/hkgMathCLR.h>

namespace Havok {
namespace Graphics {

	ref class hkgLightManagerCLR;
	ref class hkgDisplayContextCLR;

	public ref class hkgLightCLR
	{
	public:

		enum struct LightType 
		{
			OMNI = HKG_LIGHT_OMNI,
			DIRECTIONAL = HKG_LIGHT_DIRECTIONAL,
			SPOT = HKG_LIGHT_SPOT
		};

		// Allowed create cameras
		hkgLightCLR();
		~hkgLightCLR();

		bool getDesiredEnabledState();
		void setDesiredEnabledState(bool on);

		bool getIsEnabled(); 
		int getLightNumber(); 

		void enable( hkgLightManagerCLR^ manager );
		void disable( hkgLightManagerCLR^ manager );

		LightType getType();
		void setType(LightType t);

		hkgVector3CLR getPosition();
		void   setPosition(hkgVector3CLR p);

		hkgVector3CLR getDirection();
		void  setDirection(hkgVector3CLR d);

		hkgVector3CLR getDiffuse();
		void   setDiffuse(hkgVector3CLR c);

		hkgVector3CLR getSpecular();
		void   setSpecular(hkgVector3CLR c);

		hkgVector3CLR getAmbient();
		void   setAmbient(hkgVector3CLR c);

		float getSpotInnerAngle();
		float getSpotOuterAngle();
		float getSpotFalloffExponent();

		void  setSpotInnerAngle(float a);
		void  setSpotOuterAngle(float a);
		void  setSpotFalloffExponent(float a);

		void updateState(hkgDisplayContextCLR^context);

		void addShadowPlane( hkgVector4CLR plane );
		hkgMatrix4CLR getShadowMatrix(int i);
		int getNumShadowPlanes();

	internal:

		hkgLightCLR( hkgLight* toWrap );
		hkgLight* m_light;
	};



	public ref class hkgLightManagerCLR
	{
	public:
	
		// Allowed to create a manager 
		hkgLightManagerCLR(hkgDisplayContextCLR^ context);
		~hkgLightManagerCLR();

		int getNumLights();
		hkgLightCLR^ getLight(int i);
		int addLight(hkgLightCLR^ l);
		int findLight(hkgLightCLR^ l);
		hkgLightCLR^ removeLight(int i);

		int getActiveSetSize();

		hkgLightCLR^ getActiveSetLight(int i);
		void setMaxActiveSetSize(int i);

		void computeActiveSet( hkgVector3CLR worldPointOfInterest);

		void realizeActiveLights(hkgDisplayContextCLR^ context);

		void enable(int light);
		void disable(int light);

		void enable(hkgLightCLR^ light);
		void disable(hkgLightCLR^ light);

		void addSceneAmbient( hkgVector3CLR a );

		void setSceneAmbient( hkgVector3CLR a );
		hkgVector3CLR getSceneAmbient();

		void setSceneRimColor( hkgVector3CLR a );
		hkgVector3CLR getSceneRimColor();

		void addDefaultLights( float distanceFromOrigin, hkgVector3CLR up, hkgVector3CLR front, int numLights);

		hkgLightCLR^ getBestShadowCaster();
		
		void lock();
		void unlock();
		
		void setUseSceneLights(bool on);
	internal:

		hkgLightManagerCLR(hkgLightManager* toWrap);
		hkgLightManager* m_lightManager;
	};





} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
