/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

#include <Graphics/Common/Input/Pad/hkgPadDefines.h>
#include <Graphics/Common/Input/Keyboard/hkgKeyboardDefines.h>
#include <Graphics/Common/Input/Mouse/hkgMouseDefines.h>

class hkgMouse;
class hkgKeyboard;
class hkgPad;

namespace Havok {
namespace Graphics {


	public ref class hkgPadCLR
	{
	public:

		enum struct Button
		{
			NONE = 0,
			BUTTON_0 = HKG_PAD_BUTTON_0,    
			BUTTON_1 = HKG_PAD_BUTTON_1,    
			BUTTON_2 = HKG_PAD_BUTTON_2,    
			BUTTON_3 = HKG_PAD_BUTTON_3,   
			DPAD_UP = HKG_PAD_DPAD_UP,   
			DPAD_DOWN = HKG_PAD_DPAD_DOWN,   
			DPAD_LEFT = HKG_PAD_DPAD_LEFT,   
			DPAD_RIGHT = HKG_PAD_DPAD_RIGHT,  
			SELECT = HKG_PAD_SELECT,	    
			START = HKG_PAD_START,       
			BUTTON_L1 = HKG_PAD_BUTTON_L1,   
			BUTTON_R1 = HKG_PAD_BUTTON_R1,   
			BUTTON_L2 = HKG_PAD_BUTTON_L2,   
			BUTTON_R2 = HKG_PAD_BUTTON_R2,   
			BUTTON_LSTICK = HKG_PAD_BUTTON_LSTICK,  
			BUTTON_RSTICK = HKG_PAD_BUTTON_RSTICK  
		};

		value struct StickState
		{
			float m_curX;
			float m_curY;
			float m_preX;
			float m_preY;
		};

		~hkgPadCLR();	

		bool isConnected();
		void setButtonState(Button newState);
		Button getButtonState();
		Button getPrevButtonState();

		float getStickPosX(int stick);
		float getStickPosY(int stick);
		
		float getPrevStickPosX(int stick);
		float getPrevStickPosY(int stick);

		bool isButtonPressed(Button b);
		bool wasButtonPressed(Button b);
		bool wasButtonReleased(Button b);

		bool hasStickXChanged(int stick, float tolerance);
		bool hasStickYChanged(int stick, float tolerance);

		StickState^ getStickState(int stick);

	internal:

		hkgPadCLR();	
		const hkgPad* m_pad;
	};


	public ref class hkgKeyboardCLR
	{
	public:
		~hkgKeyboardCLR();

		typedef unsigned int Key; // == Virtual Keycode

		bool isConnected();
		bool getKeyState( Key key ); 
		bool getPrevKeyState( Key key ); 
		bool wasKeyPressed( Key key );
		bool wasKeyReleased( Key key );
		int numKeysPressed();
		void clear();

	internal:
		hkgKeyboardCLR();	
		const hkgKeyboard* m_keyboard;
	};


	public ref class hkgMouseCLR
	{
	public:
		
		enum struct Button
		{
			NONE = 0,
			RIGHT = HKG_MOUSE_RIGHT_BUTTON,  
			MIDDLE= HKG_MOUSE_MIDDLE_BUTTON, 
			LEFT = HKG_MOUSE_LEFT_BUTTON,   
			ANY =HKG_MOUSE_ANY_BUTTON    
		};
		
		~hkgMouseCLR();
		
		bool isConnected();

		Button getButtonState();
		int getPosX();
		int getPosY();

		Button getPrevButtonState();
		int getPrevPosX();
		int getPrevPosY();

		bool wasButtonPressed(Button b);
		bool wasButtonReleased(Button b);
		bool hasXChanged(int tolerance);
		bool hasYChanged(int tolerance);

	internal:
		hkgMouseCLR();	
		const hkgMouse* m_mouse;
	};

} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
