/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

#include <Graphics/Common/Geometry/hkgGeometryDefines.h>

class hkgGeometry;

#include <Graphics/Managed/Math/hkgMathCLR.h>

namespace Havok {
namespace Graphics {

	ref class hkgDisplayContextCLR;
	ref class hkgMaterialFaceSetCLR;
	ref class hkgMaterialCLR;
	ref class hkgGeometryPickDataCLR;
	ref class hkgRayCLR;

	public ref class hkgGeometryCLR
	{
	public:

		enum struct TransparencyType
		{
			UNKNOWN = HKG_GEOMETRY_TRANS_UNKNOWN,
			OPAQUE = HKG_GEOMETRY_TRANS_OPAQUE,
			TRANSPARENT = HKG_GEOMETRY_TRANS_TRANSPARENT,
			MIXED = HKG_GEOMETRY_TRANS_MIXED
		};

		// Allowed create geoms
		hkgGeometryCLR();
		~hkgGeometryCLR();

		int getNumMaterialFaceSets();

		hkgMaterialFaceSetCLR^ getMaterialFaceSet(int i);
		
		int addMaterialFaceSet( hkgMaterialFaceSetCLR^ ms );

		hkgMaterialFaceSetCLR^ removeMaterialFaceSet( int i);
		bool removeMaterialFaceSet( hkgMaterialFaceSetCLR^ ms );

		void setName( String^ name );
		String^ getName();

		TransparencyType getTransparencyType();

		void setMaterialOnAll( hkgMaterialCLR^ mat );

		int makeSingleFaceSet(hkgDisplayContextCLR^ context);

		void optimize();

		int intersect( hkgRayCLR^ ray, bool ignoreBackfaces, hkgGeometryPickDataCLR^ data);

		void getAABB(hkgVector3CLR minE, hkgVector3CLR maxE);
		bool hasAABB();
		void computeAABB();

		void render(hkgDisplayContextCLR^ context);
		void bake(hkgDisplayContextCLR^ context);
		void transform( hkgMatrix4CLR t);

		void recomputeAlphaSets();
		
	internal:

		hkgGeometryCLR(hkgGeometry* toWrap);
		hkgGeometry* m_geometry;
	};


} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
