/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

class hkgVertexSet;

#include <Graphics/Managed/Math/hkgMathCLR.h>
#include <Graphics/Managed/DisplayContext/hkgDisplayContextCLR.h>

#pragma unmanaged 
#include <Common/Base/hkBase.h>
#pragma managed

#include <Graphics/Common/Geometry/VertexSet/hkgVertexSetDefines.h>

namespace Havok {
namespace Graphics {

	ref class hkgRawStreamCLR;
	ref class hkgFaceSetCLR;

	public ref class hkgVertexSetCLR
	{
	public:

		enum struct Storage
		{
			NONE =		HKG_VERTEX_STORAGE_NONE,    
			V4UBC =     HKG_VERTEX_STORAGE_4UBC,
			V4UBN =     HKG_VERTEX_STORAGE_4UBN,
			V4BN = 		HKG_VERTEX_STORAGE_4BN, 
			V4UB =      HKG_VERTEX_STORAGE_4UB,
			V1F =       HKG_VERTEX_STORAGE_1F,  
			V2F =       HKG_VERTEX_STORAGE_2F,  
			V3F =       HKG_VERTEX_STORAGE_3F,  
			V4F =       HKG_VERTEX_STORAGE_4F,  
			V8UB =      HKG_VERTEX_STORAGE_8UB, 
			V2S =       HKG_VERTEX_STORAGE_2S, 
			V4S =       HKG_VERTEX_STORAGE_4S,  
			V2SN =		HKG_VERTEX_STORAGE_2SN, 
			V4SN =		HKG_VERTEX_STORAGE_4SN, 
			V2USN =     HKG_VERTEX_STORAGE_2USN,
			V4USN =		HKG_VERTEX_STORAGE_4USN,
			V2F16 =     HKG_VERTEX_STORAGE_2F16,
			V4F16 =     HKG_VERTEX_STORAGE_4F16				 
		};			 

		// Cardinal number of the vertex data (1,2,3,4 etc) for lookups
		enum struct VertexComponent
		{
			POS = HKG_VERTEX_COMPONENT_POS,					
			COLOR = HKG_VERTEX_COMPONENT_COLOR,					
			TEX0 = HKG_VERTEX_COMPONENT_TEX0,					
			TEX1 = HKG_VERTEX_COMPONENT_TEX1,					
			TEX2 = HKG_VERTEX_COMPONENT_TEX2,					
			TEX3 = HKG_VERTEX_COMPONENT_TEX3,					
			TEX4 = HKG_VERTEX_COMPONENT_TEX4,					
			TEX5 = HKG_VERTEX_COMPONENT_TEX5,					
			NORMAL = HKG_VERTEX_COMPONENT_NORMAL,					
			TANGENT = HKG_VERTEX_COMPONENT_TANGENT,				
			BITANGENT = HKG_VERTEX_COMPONENT_BITANGENT,				
			BLENDWEIGHTS= HKG_VERTEX_COMPONENT_BLENDWEIGHTS,			
			BLENDINDICES = HKG_VERTEX_COMPONENT_BLENDINDICES,			
			INSTANCED_USER_DATA = HKG_VERTEX_COMPONENT_INSTANCED_USER_DATA,	
			TOTAL_NUM = HKG_VERTEX_COMPONENT_NUM	
		};
				
		// bit field for the vertex data (1,2,4,8, etc) for format spec etc
		enum struct VertexFormat
		{
			NONE = HKG_VERTEX_FORMAT_NONE,	   	      
			POS = HKG_VERTEX_FORMAT_POS,		      
			COLOR = HKG_VERTEX_FORMAT_COLOR,           
			TEX0 = HKG_VERTEX_FORMAT_TEX0,            
			TEX1 = HKG_VERTEX_FORMAT_TEX1,            
			TEX2 = HKG_VERTEX_FORMAT_TEX2,            
			TEX3 = HKG_VERTEX_FORMAT_TEX3,            
			NORMAL = HKG_VERTEX_FORMAT_NORMAL,	      
			TANGENT = HKG_VERTEX_FORMAT_TANGENT,		  
			BITANGENT = HKG_VERTEX_FORMAT_BITANGENT,		  
			BLENDWEIGHTS = HKG_VERTEX_FORMAT_BLENDWEIGHTS,    
			BLENDINDICES = HKG_VERTEX_FORMAT_BLENDINDICES,    
			INSTANCED_USER_DATA = HKG_VERTEX_FORMAT_INSTANCED_USER_DATA 
		};

		enum struct StorageLayout
		{
			UNKNOWN = HKG_VERTEX_STORAGE_LAYOUT_UNKNOWN,
			INTERLEAVED = HKG_VERTEX_STORAGE_LAYOUT_INTERLEAVED, /* a struct with all info, so position for a vert is followed by the other info for the vert (Array of Structs) */
			PARTIAL_INTERLEAVED = HKG_VERTEX_STORAGE_LAYOUT_PARTIAL_INTERLEAVED, /* a set of structs, with commonly accessed information grouped together into buffers. For instance Pos and Normal in one buffer as skinned together normally, with Color and Texture coords in a second buffer. */
			DEINTERLEAVED = HKG_VERTEX_STORAGE_LAYOUT_DEINTERLEAVED, /* a separate buffer for each component. This can be faster to access on some platforms such as PS3, but can be bad for cache performance per vert on some platforms */
			DEFAULT = HKG_VERTEX_STORAGE_LAYOUT_DEFAULT // == (HKG_VERTEX_STORAGE_LAYOUT_PARTIAL_INTERLEAVED) 
		};

		enum struct BufferAccess
		{
			ACCESS_UNKNOWN = HKG_VERTEX_BUFFER_ACCESS_UNKNOWN,
			ACCESS_DYNAMIC = HKG_VERTEX_BUFFER_ACCESS_DYNAMIC,
			ACCESS_WRITE = HKG_VERTEX_BUFFER_ACCESS_WRITE,
			ACCESS_READ = HKG_VERTEX_BUFFER_ACCESS_READ,

			ACCESS_DEFAULT = HKG_VERTEX_BUFFER_ACCESS_DEFAULT,
			ACCESS_DYNAMIC_WRITEONLY = HKG_VERTEX_BUFFER_ACCESS_DYNAMIC_WRITEONLY,
			ACCESS_DYNAMIC_READWRITE = HKG_VERTEX_BUFFER_ACCESS_DYNAMIC_READWRITE
		};

		enum struct LockType
		{
			LOCK_NONE  = HKG_LOCK_NONE,
			LOCK_READWRITE = HKG_LOCK_READWRITE,
			LOCK_DEFAULT = HKG_LOCK_DEFAULT,
			LOCK_READONLY = HKG_LOCK_READONLY,
			LOCK_WRITEONLY = HKG_LOCK_WRITEONLY,
			LOCK_WRITEDISCARD = HKG_LOCK_WRITEDISCARD
		};

		hkgVertexSetCLR(hkgDisplayContextCLR^ ctx);
		~hkgVertexSetCLR();


		void setDesiredVertexComponentFormat( VertexComponent component, Storage s);
		void setDesiredVertexComponentLayout( StorageLayout l);
		StorageLayout getVertexComponentLayout( ); 

		void setNumVerts(int nv, VertexFormat vertexFormat, BufferAccess accessFlags);

		int getNumVerts();

		ref struct PerElementLockFlags
		{
			VertexComponent c; // comp to lock
			LockType f;	// how to lock it
		};
		
		hkgRawStreamCLR^ lock(LockType lt); //lock everything
		hkgRawStreamCLR^ partialLock(LockType lt, VertexFormat vertexFormatPartsToLock); // lock only these parts
		hkgRawStreamCLR^ partialLock(cli::array< PerElementLockFlags^ >^ lockFlags); // lock only these parts, with differing access

		void unlock(); 
		
		hkLong getVertexComponentOffset( VertexComponent component);
		int getVertexComponentStride( VertexComponent component);

		VertexFormat getVertexFormat();
		Storage getVertexComponentFormat( VertexComponent component);
		int getComponentSize( VertexComponent component );

		int getNumTextureCoordsUsed();
		
		void setVertexComponentData( VertexComponent component, int index, float v ); //HKG_VERTEX_STORAGE_1F
		void setVertexComponentData( VertexComponent component, int index, unsigned int v ); //HKG_VERTEX_STORAGE_4UB
		void setVertexComponentData( VertexComponent component, int index, float vU, float vV ); //HKG_VERTEX_STORAGE_2F
		void setVertexComponentData( VertexComponent component, int index, float X, float Y, float Z );//HKG_VERTEX_STORAGE_3F
		void setVertexComponentData( VertexComponent component, int index, float X, float Y, float Z, float W );//HKG_VERTEX_STORAGE_4F
		void setVertexComponentData( VertexComponent component, int index, hkgVector3CLR v );//HKG_VERTEX_STORAGE_3F
		void setVertexComponentData( VertexComponent component, int index, hkgVector4CLR v );//HKG_VERTEX_STORAGE_4F

		// As we cant really pass back an unmanged ptr to cast (use the hkgRawStream for that), we can use some util methods here instead
		void getVertexComponentData( VertexComponent component, int index, float& v ); //HKG_VERTEX_STORAGE_1F
		void getVertexComponentData( VertexComponent component, int index, unsigned int& v ); //HKG_VERTEX_STORAGE_4UB
		void getVertexComponentData( VertexComponent component, int index, float& vU, float& vV ); //HKG_VERTEX_STORAGE_2F
		void getVertexComponentData( VertexComponent component, int index, float& X, float& Y, float& Z );//HKG_VERTEX_STORAGE_3F
		void getVertexComponentData( VertexComponent component, int index, float& X, float& Y, float& Z, float& W );//HKG_VERTEX_STORAGE_4F
		void getVertexComponentData( VertexComponent component, int index, hkgVector3CLR% v );//HKG_VERTEX_STORAGE_3F
		void getVertexComponentData( VertexComponent component, int index, hkgVector4CLR% v );//HKG_VERTEX_STORAGE_4F
		
		void copyExistingVertex( int toThisIndex, int otherIndex, hkgVertexSetCLR^ otherSet );
		
		hkgDisplayContextCLR::MaterialVertexHint getMaterialHints();

		hkgDisplayContextCLR^ getContext();

	internal:

		hkgVertexSetCLR(hkgVertexSet* toWrap);
		hkgVertexSet* m_verts;
	};


} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
