/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

class hkgFaceSet;
class hkgFaceSetPrimitive;

#include <Graphics/Managed/Math/hkgMathCLR.h>
#include <Graphics/Common/Geometry/FaceSet/hkgFaceSetPrimitiveDefines.h>

namespace Havok {
namespace Graphics {

	ref class hkgFaceSetPrimitiveCLR;
	ref class hkgFaceSetPickDataCLR;
	ref class hkgVertexSetCLR;
	ref class hkgRayCLR;
	ref class hkgDisplayContextCLR;
	ref class hkgRawStreamCLR;
	ref class hkgBlendMatrixSetCLR;

	public ref class hkgFaceSetCLR
	{
	public:

		// Allowed create face sets
		hkgFaceSetCLR(hkgDisplayContextCLR^ context);
		~hkgFaceSetCLR();

		bool supportsLargeIndices();

		hkgVertexSetCLR^ getVertexSet(); 
		void setVertexSet(hkgVertexSetCLR^ v); 

		void addPrimitive(hkgFaceSetPrimitiveCLR^ p); 

		int getNumPrimitives();

		hkgFaceSetPrimitiveCLR^ getPrimitive(int i);
		
		//void strip(HKG_FACE_SET_STRIP_OPTIONS opts, bool stitch = true, int minStripLen = 0);
		//void tesselate( unsigned int iterations );

		void reorderVertexSet();
		void computeTangents(int textureStage);
		void weld( float tolerance );

		unsigned int intersect( hkgRayCLR^ ray, bool ignoreBackfaces, hkgFaceSetPickDataCLR^ data);
		void computeAABB(hkgVector3CLR% minE, hkgVector3CLR% maxE); 

		void initialize(array<unsigned int>^ reorderedVertices); // array can be null if you don't care

		void finalizeBlendMatrices(); // not needed on PC normally

		void render(hkgDisplayContextCLR^ context);

		void makeGrid( hkgVector3CLR corner, hkgVector3CLR sideA, hkgVector3CLR sideB, int resA, int resB, int numTexCoords, bool vcolor, bool tangents);
		void makeBox( hkgVector3CLR corner, hkgVector3CLR sideA, hkgVector3CLR sideB, hkgVector3CLR sideC, int resA, int resB, int resC, int numTexCoords, bool vcolor, bool tangents);
		void makeSphere( hkgVector3CLR center, float radius, int numMajor, int numMinor, int numTexCoords, bool vcolor, bool tangents);
		void makeCone( hkgVector3CLR from, hkgVector3CLR to, float radius0, float radius1, int numMajor, int numMinor, bool cap, int numTexCoords, bool vcolor, bool tangents);

		void collapse();
		void transform( hkgMatrix4CLR t);
		int getMaxPrimitiveBones();

	internal:

		hkgFaceSetCLR(hkgFaceSet* toWrap);
		hkgFaceSet* m_faceSet;
	};

	public ref class hkgFaceSetPrimitiveCLR
	{
	public:

		enum struct RenderType
		{
			TRI_LIST = HKG_TRI_LIST,
			STRIP = HKG_STRIP
		};

		enum struct FaceIndexSize
		{
			INDICES_NONE = HKG_INDICES_NONE,
			INDICES_UINT16 = HKG_INDICES_UINT16, 
			INDICES_UINT32 = HKG_INDICES_UINT32
		};

		// Allowed create primitives
		hkgFaceSetPrimitiveCLR(RenderType t);
		~hkgFaceSetPrimitiveCLR();

		RenderType getType();
		FaceIndexSize getIndexSize();

		void setLength(int n, bool allocateIndexBuffer, FaceIndexSize indexSize); 
		void setVertexBufferStartIndex( int n ); 
		int getLength();

		int getVertexBufferStartIndex(); 

		hkgRawStreamCLR^ getIndices16(); // may be null
		hkgRawStreamCLR^ getIndices32(); // may be null

		void setNoIndices(int len); 

		bool hasData(); 

		hkgBlendMatrixSetCLR^ getBlendMatrices(); 
		void setBlendMatrices(hkgBlendMatrixSetCLR^ bm);

	internal:

		hkgFaceSetPrimitiveCLR(hkgFaceSetPrimitive* toWrap);
		hkgFaceSetPrimitive* m_prim;
		bool m_ownPrim;

	};

} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
