/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

#include <Graphics/Common/Font/hkgFontDefines.h>

class hkgFont;

#include <Graphics/Managed/Math/hkgMathCLR.h>

namespace Havok {
namespace Graphics {

	ref class hkgDisplayContextCLR;
	ref class hkgTextureCLR;

	public ref class hkgFontCLR
	{
	public:

		// Allowed create fonts
		hkgFontCLR();
		~hkgFontCLR();

		void loadFromBuiltin(hkgDisplayContextCLR^ context, bool thick);
		bool loadFontFromFile(hkgDisplayContextCLR^ context, String^ filename);
		
		hkgTextureCLR^ getTexture(int i);
		int getNumTextures();

		void setDrawState( hkgDisplayContextCLR^ context );
		void render( hkgDisplayContextCLR^ context, String^ text, float x, float y, hkgVector4CLR color);

		void resolve( unsigned long charCode, float& u0, float& v0, float& u1, float& v1, 
							float& startX, float& startY, 
							float& relX, float& relY, 
							float& advance);
	
		void preResolve( unsigned long charCode, float& advance );

		void setCharWidth(float w);
		void setCharHeight(float h);

		float getCharWidth();
		float getCharHeight();

	internal:

		hkgFontCLR(hkgFont* toWrap);
		hkgFont* m_font;
	};


} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
