/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

class hkgDisplayWorld;

#include <Graphics/Managed/Math/hkgMathCLR.h>

namespace Havok {
namespace Graphics {

	ref class hkgAabbCLR;
	ref class hkgGeometryCLR;
	ref class hkgDisplayContextCLR;
	ref class hkgDisplayObjectCLR;
	ref class hkgLightManagerCLR;
	ref class hkgCameraCLR;
	ref class hkgWindowCLR;

	public ref class hkgDisplayWorldCLR
	{
	public:

		// Allowed create worlds
		hkgDisplayWorldCLR(hkgDisplayContextCLR^ context, bool wantManagersCreated);
		~hkgDisplayWorldCLR();

		void advanceToFrame(int frameId, bool stepObjects, hkgWindowCLR^ mainWindow);

		void addDisplayObject( hkgDisplayObjectCLR^ d );
		void insertDisplayObject( hkgDisplayObjectCLR^ d, int preferedIndex );
		
		int getNumDisplayObjects();
		hkgDisplayObjectCLR^ getDisplayObject( int i);

		hkgDisplayObjectCLR^ removeDisplayObject(int i);
		hkgDisplayObjectCLR^ removeDisplayObject(hkgDisplayObjectCLR^ o); 

		int findDisplayObject(hkgDisplayObjectCLR^ o);

		hkgLightManagerCLR^ getLightManager();
		void setLightManager( hkgLightManagerCLR^ m );

		void sortByMaterial(bool keepSorted);
		void unsort();

		void setAlphaDepthSortEnabled(bool on);
		bool getAlphaDepthSortEnabled();

		void optimize();
		void collapseStatics(hkgDisplayContextCLR^ context);
		void recomputeBoundInfo();
		void getWorldBounds( hkgAabbCLR^ bounds );
		void getShadowWorldBounds( hkgAabbCLR^ bounds, hkgCameraCLR^ currentView );

		void render(hkgDisplayContextCLR^ context, bool enableFrustumCull, bool enableShadows, bool inOverdraw );

		int getNumAlphaObjects();
		int getNumSolidObjects();
		int getNumMixedObjects();

		void renderPrelude(hkgDisplayContextCLR^ context);
		void renderObjects(hkgCameraCLR^ camera, hkgDisplayContextCLR^ context, bool enableFrustumCull, unsigned int cullObjectFilterOnBits, unsigned int cullObjectFilterOffBits );
		void frameEndCleanup();
		void setMutableObjectsUpdatedPerFrame(int i);

		void setHardwareSkinning(bool enabled);

		void lockWorld();
		void unlockWorld();

		System::IntPtr getInternalPtr();

	internal:
			
		hkgDisplayWorldCLR(hkgDisplayWorld* toWrap);
		hkgDisplayWorld* m_displayWorld;
	};


} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
