/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once


#pragma unmanaged
#include <Common/Base/hkBase.h>
#pragma managed

#include <Graphics/Common/DisplayObject/hkgDisplayObjectDefines.h>
#include <Graphics/Common/DisplayObject/hkgParticleDisplayObjectDefines.h>
#include <Graphics/Common/DisplayObject/hkgInstancedDisplayObjectDefines.h>

class hkgDisplayObject;
class hkgInstancedDisplayObject;
class hkgParticleDisplayObject;

#include <Graphics/Managed/Math/hkgMathCLR.h>
#include <Graphics/Managed/Geometry/hkgGeometryCLR.h>

namespace Havok {
namespace Graphics {

	ref class hkgMaterialCLR;
	ref class hkgRayCLR;
	ref class hkgCameraCLR;
	ref class hkgDisplayWorldCLR;
	ref class hkgDisplayObjectPickDataCLR;

	public ref class hkgDisplayKeyFrameCLR
	{};

	public ref class hkgDisplayKeyFrameObjectTransformCLR
	{
		public:
			
			hkgDisplayKeyFrameObjectTransformCLR();
			hkgDisplayKeyFrameObjectTransformCLR(IntPtr ptr);
			hkgDisplayKeyFrameObjectTransformCLR(const hkgDisplayKeyFrameObjectTransformCLR %rhs) {}
			~hkgDisplayKeyFrameObjectTransformCLR();
	};

	public ref class hkgDisplayObjectCLR
	{
	public:

		enum struct ObjectStatus
		{
			NOFLAG = HKG_DISPLAY_OBJECT_NOFLAG, 
			STATIC = HKG_DISPLAY_OBJECT_STATIC,  
			DYNAMIC = HKG_DISPLAY_OBJECT_DYNAMIC, 
			MUTABLE = HKG_DISPLAY_OBJECT_MUTABLE, 
			SHADOWCASTER = HKG_DISPLAY_OBJECT_SHADOWCASTER, 
			SHADOWRECEIVER = HKG_DISPLAY_OBJECT_SHADOWRECEIVER,
			UNLIT = HKG_DISPLAY_OBJECT_UNLIT,   
			NOT_CULLED = HKG_DISPLAY_OBJECT_NOT_CULLED,
			USER_AABB = HKG_DISPLAY_OBJECT_USER_AABB, 
			NOT_PICKABLE = HKG_DISPLAY_OBJECT_NOT_PICKABLE,  
			NO_OVERDRAW = HKG_DISPLAY_OBJECT_NO_OVERDRAW, 
			NO_AUTO_DRAW = HKG_DISPLAY_OBJECT_NO_AUTO_DRAW,
			BAKED_SCALE = HKG_DISPLAY_OBJECT_BAKED_SCALE, 
			INSTANCED = HKG_DISPLAY_OBJECT_INSTANCED, 
			PARTICLES = HKG_DISPLAY_OBJECT_PARTICLES, 
			BILLBOARD = HKG_DISPLAY_OBJECT_BILLBOARD 
		};

		enum struct CopyFlags
		{
			DEEP_COPY = HKG_DISPLAY_OBJECT_DEEP_COPY,
			SHARE_MATERIALS = HKG_DISPLAY_OBJECT_SHARE_MATERIALS ,
			SHARE_VERTS = HKG_DISPLAY_OBJECT_SHARE_VERTS ,
			SHARE_FACESETS = HKG_DISPLAY_OBJECT_SHARE_FACESETS,
			SHARE_MATFACESET = HKG_DISPLAY_OBJECT_SHARE_MATFACESETS,
			SHARE_GEOM = HKG_DISPLAY_OBJECT_SHARE_GEOM ,
			SHARE_WHOLEOBJECT = HKG_DISPLAY_OBJECT_SHARE_WHOLEOBJECT 
		};


		// Allowed create objects ( as that is kind of handy :) )
		hkgDisplayObjectCLR();
		hkgDisplayObjectCLR(IntPtr displayObject);
		~hkgDisplayObjectCLR();

		int getNumGeometry();
		void addGeometry(hkgGeometryCLR^ g);
		void setGeometry(int index, hkgGeometryCLR^ g);
		
		hkgDisplayObjectCLR^ copy( CopyFlags cf, hkgDisplayContextCLR^ ctx);
		
		void setTransform( hkgMatrix4CLR t );
		hkgMatrix4CLR getTransform( );
		
		void setSpecialState( bool forceNoZRead, bool forceNoZWrite,	bool forceWireframe, bool forceBothSides);
		void getSpecialState( bool& forceNoZRead, bool& forceNoZWrite, bool& forceWireframe, bool& forceBothSides);

		void setStatusFlags( ObjectStatus f);
		ObjectStatus getStatusFlags();
		
		hkgGeometryCLR^ getGeometry(int i);
		hkgGeometryCLR^ removeGeometry(int i, bool preserveOrder);
		hkgGeometryCLR^ removeGeometry(System::String^ name, bool preserveOrder);

		void setName( System::String^ s);
		System::String^ getName();

		hkgGeometryCLR::TransparencyType getTransparencyType();

		/// This function removes and adds back the display object, invalidating any cached indices for this object
		/// in the display world (see COM-2608).
		void setColor( hkgDisplayWorldCLR^ world, hkgVector4CLR c );
		void setMaterialOnAll( hkgMaterialCLR^ mat );

		void optimize();

		int intersect( hkgRayCLR^ ray, bool ignoreBackfaces, hkgDisplayObjectPickDataCLR^ data);

		void getAABB(hkgVector3CLR% minE, hkgVector3CLR% maxE);
		void setAABBLocal( hkgVector3CLR minE, hkgVector3CLR maxE );

		bool hasAABB();
		void computeAABB();

		bool boundsVisibleInFrustum( hkgCameraCLR^ camera );

		void render(hkgDisplayContextCLR^ context);

		void getTextureStats(int& numMatFaces, int& numTexMatFaceSets, int& numTextures );

		void computeTransparency();

		void bake(hkgDisplayContextCLR^ context);

		void setDrawLocalFrame( bool on );
		bool getDrawLocalFrame();

		void setUserPointer(int type, IntPtr d);
		IntPtr getUserPointer();
		int getUserPointerType();

		IntPtr getInternalPtr();		

		void drawTangentSpace(bool normals, bool tangents, bool biTangents, hkgDisplayContextCLR^ context);

		hkgDisplayKeyFrameObjectTransformCLR getKeyFrame(hkgDisplayKeyFrameCLR^ kfBuffer);

		void setKeyFrame(hkgDisplayKeyFrameCLR^ kfBuffer, hkgDisplayKeyFrameObjectTransformCLR^ transformIn);

	internal:
		hkgDisplayObjectCLR(hkgDisplayObject* toWrap);				
		hkgDisplayObject* m_displayObject;
	};


	public ref class hkgInstancedDisplayObjectCLR : public hkgDisplayObjectCLR
	{
	public:

		enum struct DisplayMode
		{
			CPU = HKG_INSTANCED_DISPLAY_CPU, // transforms assumed to just be as is on the CPU, don't use any particular shader dependant techniques etc
			TCOORD123 = HKG_INSTANCED_DISPLAY_TCOORD123 // transforms given as texture coords to the shader, will use any available techniques (Default)
		};

		hkgInstancedDisplayObjectCLR(hkgDisplayContextCLR^ context);
	
		void setMaxNumObjects( int numObjects, int numBonesPerObject, bool allocateBuffers, int perBoneExtraDataSize);
		void setNumObjects( int numObjects );

		void setRenderMode(DisplayMode mode);
		DisplayMode getRenderMode(); 

		int getNumObjects();

		void setTransform( hkgMatrix4CLR transform, int objectIdx );
		hkgMatrix4CLR getTransform( int objectIdx );

		void setStartTransformIndex( int index );
		int getStartTransformIndex();

		IntPtr getUserShapeId();
		void setUserShapeId(IntPtr id);

		void setUserDataAtIndex( int index, IntPtr d ); 
		IntPtr getUserDataFromIndex( int index ); 

	internal:

		hkgInstancedDisplayObjectCLR(hkgInstancedDisplayObject* toWrap);
	};


	public ref class hkgParticleDisplayObjectCLR : public hkgDisplayObjectCLR
	{
	public:

		enum struct DisplayMode
		{
			SIMPLE = HKG_PARTICLE_DISPLAY_SIMPLE,      
			POINT = HKG_PARTICLE_DISPLAY_POINT,
			POINTSPRITE = HKG_PARTICLE_DISPLAY_POINTSPRITE, 
			MOTION = HKG_PARTICLE_DISPLAY_MOTION      
		};

		enum struct BlendMode
		{
			NONE = HKG_PARTICLE_BLEND_NONE,         
			ADDITIVE = HKG_PARTICLE_BLEND_ADDITIVE,     
			SUBTRACTIVE = HKG_PARTICLE_BLEND_SUBTRACTIVE, 
			MODULATE = HKG_PARTICLE_BLEND_MODULATE    
		};

		hkgParticleDisplayObjectCLR(hkgDisplayContextCLR^ context);

		void setMaxNumParticles( int numParticles, bool allocateBuffers );

		void setPosition( hkgVector3CLR position, int objectIdx );
		hkgVector3CLR getPosition( int objectIdx );

		void setVelocity( hkgVector3CLR vel, int objectIdx ); // == tcoord
		hkgVector3CLR getVelocity( int objectIdx );

		virtual void setUserData( hkgVector3CLR ud, int objectIdx ); // == tcoord
		hkgVector3CLR getUserData( int objectIdx );

		void setNumParticles( int numParticles );
		void setStartIndex( int index );
		int getNumParticles();
		int getStartIndex();

		void setMaterial( hkgMaterialCLR^ m );
		hkgMaterialCLR^ getMaterial();
		
		void setRenderMode( DisplayMode m );
		DisplayMode getRenderMode(); 

		void setBlendMode( BlendMode m );
		BlendMode getBlendMode();

		// auto set shader params:
		void setParticlePointSize(float size);
		void setParticleTime( float t );
		void setParticleLifeTime( float t );

		IntPtr getUserId();
		void setUserId(IntPtr id);

	internal:

		hkgParticleDisplayObjectCLR(hkgParticleDisplayObject* toWrap);
	};

} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
