/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#pragma once

#include <Graphics/Managed/Math/hkgMathCLR.h>

class hkgFaceSet;

namespace Havok
{
	namespace Graphics
	{
		ref class hkgGeometryCLR;
		ref class hkgDisplayObjectCLR;
		ref class hkgDisplayContextCLR;

			/// Utility class to build hkgDisplayObjects. 
		public ref class hkgDisplayObjectBuilderCLR
		{
			public:
					/// Builds a box
				static hkgGeometryCLR^ buildBox( hkgDisplayContextCLR^ context, hkgVector3CLR corner, hkgVector3CLR sideA, hkgVector3CLR sideB, hkgVector3CLR sideC, hkgVector4CLR color );

					/// Builds a plane
				static hkgGeometryCLR^ buildPlane( hkgDisplayContextCLR^ context, hkgVector3CLR corner, hkgVector3CLR sideA, hkgVector3CLR sideB, hkgVector4CLR color );
		
			protected:
					/// Builds a hkgGeometry from a face set and color
				static hkgGeometryCLR^ buildGeometry( hkgFaceSet* faceSet, hkgVector4CLR color );
		};
	}
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
