/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

#include <Graphics/Common/DisplayContext/hkgDisplayContextDefines.h>

class hkgDisplayContext;

#include <Graphics/Managed/Math/hkgMathCLR.h>

namespace Havok {
namespace Graphics {

	ref class hkgWindowCLR;
	ref class hkgViewportCLR;
	ref class hkgCameraCLR;
	ref class hkgLightCLR;
	ref class hkgMaterialCLR;
	ref class hkgShaderEffectCLR;
	ref class hkgTextureCLR;
	ref class hkgBlendMatrixSetCLR;
	ref class hkgShaderEffectCollectionCLR;
	ref class hkgVertexSetCLR;

	public ref class hkgDisplayContextCLR
	{
	public:

		~hkgDisplayContextCLR();

		enum struct VertexOptions
		{
			USE_STREAMS = HKG_VTX_USE_STREAMS,
			DISABLE_TEXTURE2D = HKG_VTX_DISABLE_TEXTURE2D,
			DISABLE_COLOR = HKG_VTX_DISABLE_COLOR	 
		};

		enum struct EnabledState
		{
			NONE = HKG_ENABLED_NONE,					
			LIGHTING = HKG_ENABLED_LIGHTING,				
			TEXTURE2D = HKG_ENABLED_TEXTURE2D,	
			MATERIALOVERRIDE = HKG_ENABLED_MATERIAL_OVERRIDE,
			ALPHABLEND = HKG_ENABLED_ALPHABLEND,				
			ZREAD = HKG_ENABLED_ZREAD,		
			ZWRITE = HKG_ENABLED_ZWRITE,
			CULLFACE = HKG_ENABLED_CULLFACE,	
			WIREFRAME = HKG_ENABLED_WIREFRAME
		};


		enum struct BlendMode
		{
			MODULATE = HKG_BLEND_MODULATE,
			ADD = HKG_BLEND_ADD   
		};

		enum struct TextureMode
		{
			MODULATE = HKG_TEXTURE_MODULATE,
			DECAL = HKG_TEXTURE_DECAL
		};	
		
		enum struct CullFaceMode
		{
			CW = HKG_CULLFACE_CW,
			CCW = HKG_CULLFACE_CCW 
		};

		enum struct ColorMode
		{
			MATERIAL = HKG_COLOR_MATERIAL,
			GLOBAL = HKG_COLOR_GLOBAL,
			GLOBAL_SHADER = HKG_COLOR_GLOBAL_SHADER,
			GLOBAL_SHADER_COLLECTION = HKG_COLOR_GLOBAL_SHADER_COLLECTION
		};
		
		enum struct TextureStageLockMode
		{
			UNLOCKED = HKG_TEXTURE_STAGE_ALL_UNLOCKED,
			TEXTURE0 = HKG_TEXTURE_STAGE_LOCKED_TEXTURE0,
			TEXTURE1 = HKG_TEXTURE_STAGE_LOCKED_TEXTURE1,
			TEXTURE2 = HKG_TEXTURE_STAGE_LOCKED_TEXTURE2,
			TEXTURE3 = HKG_TEXTURE_STAGE_LOCKED_TEXTURE3,
			TEXTURE4 = HKG_TEXTURE_STAGE_LOCKED_TEXTURE4,
			TEXTURE5 = HKG_TEXTURE_STAGE_LOCKED_TEXTURE5,
			TEXTURE6 = HKG_TEXTURE_STAGE_LOCKED_TEXTURE6,
			TEXTURE7 = HKG_TEXTURE_STAGE_LOCKED_TEXTURE7
		};


		enum struct MaterialVertexHint
		{
			NONE = HKG_MATERIAL_VERTEX_HINT_NONE,
			VCOLOR = HKG_MATERIAL_VERTEX_HINT_VCOLOR,
			TANGENTS = HKG_MATERIAL_VERTEX_HINT_TANGENTS,
			BLENDING = HKG_MATERIAL_VERTEX_HINT_BLENDING
		};

		enum struct ImmGroup
		{
			LINES = HKG_IMM_LINES,
			LIST = HKG_IMM_TRIANGLE_LIST,
			STRIP = HKG_IMM_TRIANGLE_STRIP,
			POINTS = HKG_IMM_POINTS
		};

		enum struct DebugFlags
		{
			NONE = HKG_DEBUG_NONE,
			PRIMITIVES = HKG_DEBUG_PRIMITIVES 
		};


		enum struct RenderPassInfo
		{
			NORMAL = HKG_RENDER_PASS_NORMAL,		
			TO_DEPTHMAP = HKG_RENDER_PASS_TO_DEPTHMAP,
			USING_DEPTHMAP = HKG_RENDER_PASS_USING_DEPTHMAP	
		};

				
		int advanceFrame();
		int getCurrentFrameId(); 

		VertexOptions getVertexOptions();
		void setVertexOptions( VertexOptions o );

		void setCurrentViewport(hkgViewportCLR^ v);
		hkgViewportCLR^ getCurrentViewport();
	
		hkgMaterialCLR^	getCurrentMaterial();
		MaterialVertexHint getCurrentMaterialHints();

		hkgShaderEffectCLR^ getCurrentShaderEffect();
		hkgBlendMatrixSetCLR^ getCurrentBlendMatrices();
		hkgShaderEffectCollectionCLR^ getCurrentGlobalShaderEffectCollection( );

		void setCurrentSoleTexture(hkgTextureCLR^ t, TextureMode mode); 
		void setCurrentMaterial(hkgMaterialCLR^ m, hkgVertexSetCLR^ vhints ); 
		void setCurrentShaderEffect(hkgShaderEffectCLR^ s, hkgVertexSetCLR^ vhints ); 
		void setCurrentBlendMatrices(hkgBlendMatrixSetCLR^ bm);
		void setCurrentGlobalShaderEffectCollection(hkgShaderEffectCollectionCLR^ gs );

		hkgWindowCLR^ getOwner();
		
		EnabledState getEnabledState();	
		
		void setLightingState(bool on);
		void setTexture2DState(bool on);
		void setBlendState(bool on);
		void setDepthReadState(bool on);
		void setDepthWriteState(bool on);
		void setCullFaceState(bool on );
		void setWireframeState(bool on);
		void setLightState(int light, bool on);
		void setDepthBias(float val);
		void setShadowVsmBias(float bias, float epsilon);
		int getMaxNumLights();

		void matchState( EnabledState desiredState, CullFaceMode desiredCullfaceMode, BlendMode desiredBlendMode );
		void syncState(); 

		CullFaceMode getCullfaceMode();
		void setCullfaceMode( CullFaceMode m );

		BlendMode getBlendMode();
		void setBlendMode( BlendMode m );

		/// How color is set
		ColorMode getColorMode();
		void setColorMode( ColorMode c );

		DebugFlags getDebugFlags();
		void setDebugFlags( DebugFlags c );

		RenderPassInfo getRenderPassInfo();
		void setRenderPassInfo( RenderPassInfo p );

		TextureStageLockMode getTextureStageLockMode();
		void setTextureStageLockMode( TextureStageLockMode l );

		void popMatrix();
		void pushMatrix();
		void multMatrix(hkgMatrix4CLR m);
		void beginGroup(ImmGroup type);
		void setCurrentColor3( hkgVector3CLR c);
		void setCurrentColor4( hkgVector4CLR c);
		void setCurrentColorPacked( unsigned int c); 

		// normaly only use the first 2 components of this texture coord vec:
		void setCurrentTextureCoord(hkgVector3CLR t);
		void setCurrentNormal(hkgVector3CLR n);
		void setCurrentPosition(hkgVector3CLR p);
		void endGroup(bool useCurrentShaders);
		void flush();

		void drawUnitAxis(bool setState);

		void feedShaders(bool onlyFeedDirty, hkgVertexSetCLR^ vhints);
		
		void lockContext();
		void unlockContext();

		hkgMaterialCLR^ getDefaultMaterial();
		void setMaterialOverride(hkgMaterialCLR^ mtlOverride);

		hkgMaterialCLR^ getDefaultMaterialOverride();

		int getNumCurrentTextures();

		void setMaxAnisotropy(int i); 
		int getMaxAnisotropy();

		System::IntPtr getInternalPtr();

	internal:

		// Not allowed create context (owned by window, provides an interface to some of the underlying api etc)
		hkgDisplayContextCLR(hkgDisplayContext* toWrap);
		hkgDisplayContext* m_context;
	};




} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
