/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

class hkgCamera;

#include <Graphics/Managed/Math/hkgMathCLR.h>
#include <Graphics/Common/Camera/hkgCameraDefines.h>

namespace Havok {
namespace Graphics {

	ref class hkgDisplayContextCLR;
	ref class hkgLightCLR;

	public ref class hkgCameraCLR
	{
	public:

		enum struct ProjectionMode
		{
			PERSPECTIVE = HKG_CAMERA_PERSPECTIVE,  
			ORTHOGRAPHIC = HKG_CAMERA_ORTHOGRAPHIC, 
			COMPUTE_ORTHOGRAPHIC = HKG_CAMERA_COMPUTE_ORTHOGRAPHIC
		};
		
		static float DEFAULT_NEAR_PLANE = HKG_CAMERA_DEFAULT_NEAR_PLANE;
		static float DEFAULT_FAR_PLANE = HKG_CAMERA_DEFAULT_FAR_PLANE;
		static float STANDARD_ASPECT = HKG_CAMERA_STANDARD_ASPECT;	
		static float WIDESCREEN_ASPECT = HKG_CAMERA_WIDESCREEN_ASPECT;
		static float DEFAULT_ASPECT = HKG_CAMERA_DEFAULT_ASPECT;

		enum struct HandednessMode
		{
			RIGHT = HKG_CAMERA_HANDEDNESS_RIGHT, 
			LEFT = HKG_CAMERA_HANDEDNESS_LEFT
		};
		
		// Allowed create cameras
		hkgCameraCLR();
		~hkgCameraCLR();

		void advanceToFrame(int frameId);
		int getCurrentFrameId();

		void orthogonalize();
		void computeProjection();
		void computeModelView( bool forceIdentity );

		ProjectionMode getProjectionMode();
		void setProjectionMode(ProjectionMode m);
		HandednessMode getHandednessMode();
		void setHandednessMode(HandednessMode m);

		void project( float x, float y, float z, int winWidth, int winHeight, hkgVector3CLR% result );
		void unProject( int x, int y, float depth, int winWidth, int winHeight, hkgVector3CLR% result );
		void unProjectExact( int x, int y, float depth, int winWidth, int winHeight, hkgVector3CLR% result );
		
		void setAsCurrent(hkgDisplayContextCLR^ state);

		void pan(float x_amount, float y_amount, bool move_focus, bool proportional);
		void dolly(float z_amount, bool move_focus, bool proportional );
		void rotateAboutTo(float angle, hkgVector3CLR axis, bool upLock );
		void rotateAboutFrom(float angle, hkgVector3CLR axis, bool upLock );
		void startTrackball( unsigned int winWidth, unsigned int winHeight, int mouseX, int mouseY );
		void moveTrackball( unsigned int winWidth, unsigned int winHeight, int mouseX, int mouseY );
		
		void getFrom(hkgVector3CLR% f);				
		void getTo(hkgVector3CLR% t);
		void getDir(hkgVector3CLR% d);
		void getRight(hkgVector3CLR% r);
		
		void getUp(hkgVector3CLR% u);
		void getBestAlignedUpVector(hkgVector3CLR% bestWorldUp);

		float	getFOV();
		float	getNear();		
		float	getFar();		
		float	getAspect();	
		hkgVector3CLR getDir();
		hkgVector3CLR getUp();				
		hkgVector3CLR getTo();				
		hkgVector3CLR getFrom();				
	
		void setFOV(float f); 
		void setNear(float f);
		void setFar(float f);
		void setAspect(float f);
		void setUp(hkgVector3CLR u);
		void setTo(hkgVector3CLR t);
		void setFrom(hkgVector3CLR f);

		float getOrthoLeft();
		float getOrthoRight();
		float getOrthoTop();
		float getOrthoBottom();
		float getOrthoNear();
		float getOrthoFar();
		
		void setOrthoLeft(float l);
		void setOrthoRight(float r);
		void setOrthoTop(float t);
		void setOrthoBottom(float b);
		void setOrthoNear(float n);
		void setOrthoFar(float f);

		void computeOrtho( float left, float right, float bottom, float top, float znear, float zfar);
		void computeOrthoParams();
		void computePerspective( float fov, float aspect, float znear, float zfar);
		void computeFrustumPlanes();	
		void computeCameraInverse(); // will store as m_camInv locally. Will call the following 2 funcs:
		void computeInverseProjectionMatrix( hkgMatrix4CLR% inv );
		void computeInverseViewMatrix( hkgMatrix4CLR% inv );
		float computeBillboardMatrix( hkgVector3CLR pos, hkgMatrix4CLR% billboard );
		float computeIconVerticalDrawSize( float distanceFromCam, int desiredPixelCoverage, int viewportHeight );

		hkgMatrix4CLR getProjectionMatrix();
		hkgMatrix4CLR getViewMatrix();
		hkgMatrix4CLR getCameraInverseMatrix();
		hkgVector4CLR getFrustumPlane(unsigned int i); 

		bool sphereVisible(hkgVector3CLR c, float radius); // in world space
		
		void setCameraName( String^ name );
		String^ getCameraName();

		hkgMatrix4CLR getPlatformViewMatrix();
		hkgMatrix4CLR getPlatformProjectionMatrix();
		
		static hkgCameraCLR^ createFixedShadowFrustumCamera( hkgLightCLR^ light, hkgAabbCLR^ areaOfInterest, bool tightProjection, float extraNear /*= 0*/, float extraFar /*= 0*/);

	internal:

		hkgCameraCLR(hkgCamera* toWrap);
		hkgCamera* m_camera;
	};



} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
