/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HK_IMGUI_PAINTER_H
#define HK_IMGUI_PAINTER_H

namespace ImGui
{
		/// This provides GUI theming.
		/// Painting is a two step process - the layout will generally make several calls to measure* methods which tells it how big a widget needs to
		/// be in order to contain a child of a given size. The layout then arranges and places them by calling paint* method. Each paint* method returns
		/// the a rectangle which is where the child should be drawn.
	struct Painter
	{
		EXT_SIMPLE_ALLOCATOR();

			/// Opaque texture type.
		struct Texture;

			/// Dtor
		virtual ~Painter() = 0;

			/// Return the size of the button, based on the size passed in
		virtual Pair measureButton(const Pair& contents) = 0;
			/// Paint a button in the specified rectangle, using the widget flags. Returns the 
			/// inner rectangle - where text can be drawn.
		virtual Rectangle paintButton(const Rectangle& rect, WidgetFlags state) = 0;

			/// Create a new texture as a copy of the given buffer.
		virtual const Texture* createTexture( const hkUint32* argb, int w, int h ) = 0;

			/// Return the size of the image, based on the width and height passed in.	
			/// It may not be the same a width,height if the screen is scaled.
		virtual Pair measureImage(int width, int height) = 0;
			/// Paint an image from a precreated renderer specific texture.
		virtual Rectangle paintImage(const Rectangle& rect, const Texture* texture, ImGui::Argb color) = 0;

			/// Measure the size of a 'tab' (used for tab icons)
		virtual Pair measureTab(const Pair& contents) = 0;
			/// Paint a tab using the specified rect and widget flags. Returns the inner
			/// rectangle - where text can be drawn.
		virtual Rectangle paintTab(const Rectangle& rect, WidgetFlags state) = 0;

			/// Measure a notebook for tab height
		virtual Pair measureNotebook(const Pair& contents) = 0;
			/// Paint a notebook using the specified rect and widget flags.
		virtual void paintNotebook(const Rectangle& wholeRect, const Pair& tabSize, WidgetFlags state) = 0;

			/// Paint a window with specified rect, and widget flags. Returns the inner
			/// window (client area) rectangle.
		virtual Rectangle paintWindow(const Rectangle& window, WidgetFlags state, hkBool hasTitle) = 0;
		
			/// Paint a scroll bar
		virtual void paintScrollBar(int axis, const Rectangle& rect, int curPos, int scrolledSize, WidgetFlags state) = 0;

			/// Measure the size of a progress bar. 
		virtual Pair measureProgress(int axis, const Pair& child) = 0;
			/// Paint the progress bar. Returns inner rectangle of contents area, where 
			/// text can be drawn.
		virtual Rectangle paintProgress(int axis, const Rectangle& rect, hkReal frac) = 0;

			/// Measure the size of a spinner.
		virtual Pair measureSpinner(const Pair& child) = 0;
			/// Paint a spinner. Returns the rectangle where the contents of the spinner can be drawn.
		virtual Rectangle paintSpinner(const Rectangle& rect, WidgetFlags state) = 0;

			/// Measure radio button size
		virtual Pair measureRadio(const char* text) const = 0;
			/// Draw a radio button
		virtual void paintRadio(const Rectangle& rect, const char* text, WidgetFlags flags) = 0;

			/// Measure tree
		virtual Pair measureTree( int level, hkBool expandable ) = 0;
			/// Draw a tree
		virtual void paintTree(const Rectangle& rect, int level, hkBool expandable, hkBool open, WidgetFlags flags) = 0;

			/// Measure an expander
		virtual Pair measureExpander( const Pair& child ) = 0;
			/// Draw an expander. Returns the rectangle where text associated with the expander can be drawn.
		virtual Rectangle paintExpander(const Rectangle& label, const Rectangle& whole, hkBool open, WidgetFlags state) = 0;

			/// Measure text and return the size text will take up.
		virtual Pair measureText( const char* text ) const = 0;
			/// Paint text
		virtual void paintTextColor( const Rectangle& pos, const char* text, ImGui::Argb color ) = 0;
		virtual void paintText( const Rectangle& pos, const char* text, WidgetFlags flags) = 0;


			/// TODO REMOVE ME Draw a rectangle and fill with specified color.
		virtual void fillRectangle( const Rectangle& rect, ImGui::Argb color ) = 0;
			///
		virtual void _paintTriangle(const Rectangle& r, Direction direction, ImGui::Argb color) = 0;


			/// Draw a highlight. Zero color means auto.
		virtual void highlight(const Rectangle& rect, hkUint32 argb=0) = 0;

			/// Gets the maximum character width
		virtual int getMaxCharWidth() const = 0;
			/// Get the maximum character height
		virtual int getMaxCharHeight() const = 0;
			/// Calculate the index in the text most appropriate for the pixel offset, from the start of the text
		virtual int charIndexFromOffset( const char* text, int off) const = 0;

			/// Get the current clip rectangle.
		virtual const Rectangle& getClipRect() const = 0;
			/// Push a new clip rectangle.
			/// The rectangle overwrites the clip area - it is not intersected.
		virtual void pushClipRect(const Rectangle& inner) = 0;

			/// Pop the clipstack and return current clip region.
		virtual Rectangle popClipRect() = 0;

			/// Use the z buffer to handle drawing overlaps
		virtual void adjustDepth(int factor) = 0;
	};

		/// Utility class for storing render commands
	class RenderBuffer
	{
		public:

			RenderBuffer();
			~RenderBuffer();

			struct Tri
			{
				void set( Pair a, Pair b, Pair c, int dep, int col, int cindex)
				{
					pts[0] = a; pts[1] = b; pts[2] = c; 
					color[0] = color[1] = color[2] = col; 
					depth = dep; 
					clipIndex = cindex;
				}
				void set( Pair a, Pair b, Pair c, int dep, int ca, int cb, int cc, int cindex)
				{
					pts[0] = a; pts[1] = b; pts[2] = c; 
					color[0] = ca; color[1] = cb; color[2] = cc; 
					depth = dep; 
					clipIndex = cindex;
				}
				Pair pts[3];
				ImGui::Argb color[3];
				int depth;
				int clipIndex;
			};
			struct Str
			{
				Pair pos;
				hkStringPtr text;
				int scale;//16.16 fixed pt
				int depth;
				ImGui::Argb color;
				int clipIndex;
			};
			struct Img
			{
				int textureIndex;
				Rectangle srcRect;
				Rectangle dstRect;
				ImGui::Argb color;
				int clipIndex;
				int m_depth;
			};
			struct Tex
			{
				Tex();
				~Tex();
				void set(const hkUint32*, int w, int h);
				hkUint32* m_argb; // can be a platform ptr too (if lower bit is 1, then does not own the data / assume to know what it is)
				int m_width;
				int m_height;
			};
			struct Line
			{
				void set( Pair a, Pair b, int dep, int col, int cindex)
				{
					pts[0] = a; pts[1] = b;
					color[0] = color[1] = col; 
					depth = dep; 
					clipIndex = cindex;
				}
				Pair pts[2];
				ImGui::Argb color[2];
				int depth;
				int clipIndex;
			};

 			int createTexture( const hkUint32* argb, int w, int h );
			void paintImage( const Rectangle& rect, int textureId, ImGui::Argb color );
			void paintText( const Rectangle& pos, const char* text, ImGui::Argb color );

			const Rectangle& getClipRect() const;
			void pushClipRect(const Rectangle& inner);
			Rectangle popClipRect();
			void adjustDepth(int factor);

			void fillRectangle( const Rectangle& rect, ImGui::Argb color );
			void fillRectangle2( const Rectangle& rect, const int c[4] );
			void fillTriangle( const Pair& a, const Pair& b, const Pair& c, ImGui::Argb color );
			void fillTriangle2( const Pair& a, const Pair& b, const Pair& c, int ca, int cb, int cc );
			void fillQuad( const Pair& a, const Pair& b, const Pair& c, const Pair& d, ImGui::Argb color );
			void fillQuad2( const Pair& a, const Pair& b, const Pair& c, const Pair& d, int ca, int cb, int cc, int cd );

			void lineQuad( const Pair& a, const Pair& b, const Pair& c, const Pair& d, ImGui::Argb color );
			void line( const Pair& a, const Pair& b, ImGui::Argb color );

		public:

			hkArray<Tri> m_fillTris;
			hkArray<Str> m_strings;
			hkArray<Img> m_images;
			hkArray<Tex> m_textures;
			hkArray<Line> m_lines;
			hkArray<Rectangle> m_clips; 
			hkArray<int> m_clipStack; 
			int m_depth;
	};
}

#endif // HK_IMGUI_PAINTER_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
