/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

namespace ImGui
{
	inline hkUint32* fromPlatformPointer( void* platformPtr )
	{
		return (hkUint32*)( ((hkUlong)platformPtr) | 0x1 );
	}

	/* !!!!!!!!!!!!!!!!!!!!!!!!! Pair !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
	
	
	Pair::Pair( int _x, int _y ) 
	{ 
		x[0] = _x;
		x[1] = _y; 
	}
	void Pair::set( int _x, int _y ) 
	{ 
		x[0] = _x;
		x[1] = _y; 
	}
	void Pair::setZero() 
	{ 
		x[0] = x[1] = 0; 
	}
	void Pair::setAdd( const Pair& p, const Pair& q) 
	{ 
		x[0] = p[0] + q[0]; 
		x[1] = p[1] + q[1]; 
	}
	void Pair::setSub( const Pair& p, const Pair& q) 
	{ 
		x[0] = p[0] - q[0]; 
		x[1] = p[1] - q[1]; 
	}
	void Pair::setMin( const Pair& p, const Pair& q) 
	{ 
		x[0] = hkMath::min2(p[0],q[0]); 
		x[1] = hkMath::min2(p[1],q[1]); 
	}
	void Pair::setMax( const Pair& p, const Pair& q) 
	{ 
		x[0] = hkMath::max2(p[0], q[0]); 
		x[1] = hkMath::max2(p[1], q[1]); 
	}
	void Pair::setMid( const Pair& p, const Pair& q) 
	{ 
		x[0] = (p[0] + q[0]) / 2; 
		x[1] = (p[1] + q[1]) / 2; 
	}
	void Pair::add( int _x, int _y ) 
	{ 
		x[0] += _x; 
		x[1] += _y; 
	}
	void Pair::add( const Pair& p ) 
	{ 
		x[0] += p[0]; 
		x[1] += p[1]; 
	}
	void Pair::sub( int _x, int _y ) 
	{ 
		x[0] -= _x; 
		x[1] -= _y; 
	}
	void Pair::sub( const Pair& p ) 
	{ 
		x[0] -= p[0]; 
		x[1] -= p[1]; 
	}
	int& Pair::operator[](int i) 
	{ 
		HK_ASSERT(0x363cf4d9, unsigned(i) < 2); 
		return x[i]; 
	}
	int Pair::operator[](int i) const 
	{ 
		HK_ASSERT(0x363cf4d9, unsigned(i) < 2);	
		return x[i]; 
	}
	void Pair::operator+=(const Pair& p) 
	{ 
		x[0] += p.x[0]; 
		x[1] += p.x[1]; 
	}
	void Pair::operator-=(const Pair& p) 
	{ 
		x[0] -= p.x[0]; 
		x[1] -= p.x[1]; 
	}
	hkBool32 Pair::operator==(const Pair& p) const 
	{ 
		return x[0] == p.x[0] && x[1] == p.x[1]; 
	}
	hkBool32 Pair::operator!=(const Pair& p) const 
	{ 
		return x[0] != p.x[0] || x[1] != p.x[1]; 
	}
	hkUint64 Pair::pack() const
	{ 
		return (hkUint64(x[0])<<32) | x[1];
	}
	void Pair::unpack(hkUint64 u) 
	{ 
		x[0] = int(u >> 32); 
		x[1] = int(u); 
	}

/* !!!!!!!!!!!!!!!!!!!!!!!!! Rectangle !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/

	Rectangle::Rectangle(int _x, int _y, int _w, int _h)
	{
		pos[0] = _x;
		pos[1] = _y;
		size[0] = _w;
		size[1] = _h;
	}

	Rectangle::Rectangle(const Pair& posIn, const Pair& sizeIn) : 
		pos(posIn), 
		size(sizeIn)
	{
	}
	void Rectangle::init()
	{
		pos.set(-1,-1);
		size.set(-1,-1);
	}
	hkBool32 Rectangle::operator==( const Rectangle& r ) const
	{
		return (size == r.size) && (pos == r.pos);
	}
	hkBool32 Rectangle::operator!=( const Rectangle& r ) const
	{
		return (size != r.size) || (pos != r.pos);
	}
	hkBool Rectangle::contains(const Pair& p ) const
	{
		return p[0] >= pos[0] 
			&& p[1] >= pos[1]
			&& p[0]-pos[0] < size[0]
			&& p[1]-pos[1] < size[1];
	}

	Rectangle Rectangle::intersect(const Rectangle& r) const
	{
		int lhs = hkMath::max2(r.pos[0], pos[0]);
		int rhs = hkMath::min2(r.pos[0] + r.size[0], pos[0] + size[0]);

		int top = hkMath::max2(r.pos[1], pos[1]);
		int bot = hkMath::min2(r.pos[1] + r.size[1], pos[1] + size[1]);

		return Rectangle(lhs, top, rhs - lhs, bot - top);
	}
	hkBool Rectangle::overlaps( const Rectangle& r ) const
	{
		const Pair& minA = pos;
		const Pair& minB = r.pos;
		Pair maxA; maxA.setAdd(pos, size);
		Pair maxB; maxB.setAdd(r.pos, r.size);
		return	minA[0] < maxB[0] && minB[0] < maxA[0]
			&&	minA[1] < maxB[1] && minB[1] < maxA[1];
	}
	void Rectangle::set( int x, int y, int sx, int sy)
	{
		pos.set(x,y);
		size.set(sx,sy);
	}
	void Rectangle::include( const Rectangle& r )
	{
		pos.setMin( pos, r.pos );
		Pair c0; c0.setAdd( pos, size );
		Pair c1; c1.setAdd( r.pos, r.size );
		Pair mx; mx.setMax(c0, c1);
		size.setSub(mx, pos);
	}
	Rectangle Rectangle::clipped( int left, int right, int top, int bottom ) const
	{
		return Rectangle(pos[0]+left, pos[1]+top, size[0]-left-right, size[1]-top-bottom);
	}
	void Rectangle::clip( int left, int right, int top, int bottom )
	{
		pos[0] += left;
		pos[1] += top;
		size[0] -= left-right;
		size[1] -= top-bottom;
	}

	Pair Rectangle::mid() const
	{
		return Pair( pos[0]+size[0]/2, pos[1]+size[1]/2 );
	}

	Rectangle Rectangle::shrunk( int dx, int dy ) const
	{
		Rectangle r = *this;
		r.shrink(dx,dy);
		return r;
	}
	void Rectangle::shrink( int dx, int dy )
	{
		pos[0] += dx;
		pos[1] += dy;
		size[0] -= 2*dx;
		size[1] -= 2*dy;
	}
	void Rectangle::move( int dx, int dy )
	{
		pos[0] += dx;
		pos[1] += dy;
	}

		
	void Rectangle::corners(Pair p[4]) const
	{
		// UL, UR, LR, LL
		p[0] = pos;
		p[1] = pos; p[1].add( size[0], 0);
		p[2] = pos; p[2].add( size[0], size[1]);
		p[3] = pos; p[3].add( 0, size[1]);
	}

	int Rectangle::area() const
	{
		return size[0] * size[1];
	}

	void Rectangle::shrink( const Pair& p )
	{
		shrink( p[0], p[1] );
	}

}  // namespace ImGui

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
