/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HK_IMGUI_H
#define HK_IMGUI_H

#include <Common/Base/hkBase.h>
#include <Common/Base/Ext/hkBaseExt.h>

#define EXT_SIMPLE_ALLOCATOR() \
	void* operator new(hk_size_t nbytes) { return hkMemoryRouter::easyAlloc( extAllocator::getInstance(), int(nbytes) ); } \
	void  operator delete(void* p, hk_size_t nbytes) { if (p) { return hkMemoryRouter::easyFree( extAllocator::getInstance(), p); }  } \

	/// Immediate Mode GUI namespace.
	/// In an nutshell, an immediate mode GUI (ImGui) gathers the creation,
	/// update and results of the GUI operation into a single place.
	/// Theres a good tutorial and introduction at http://iki.fi/sol/imgui/
	/// One of the oldest mentions is a video at http://mollyrocket.com/861
	///
	/// This implementation differs somewhat from both the above but the major components match.
	/// For instance, we don't need to generate or pass widget IDs. We don't require manual layout
	/// but have automatic widget layout. We don't have a separate "hot" tracking. We rely on the
	/// widgets being non-overlapping and windows drawn (and thus handled) in front to back order.
namespace ImGui
{
	typedef hkUint32 Argb;

	/// Mangle a platform (texture) pointer (see ImGui::RenderBuffer::Tex, hkgImGui.cpp/_isPrecreated())
	hkUint32* fromPlatformPointer( void* platformPtr );

	/// Holds a pair of integers.
	struct Pair
	{
		HK_DECLARE_POD_TYPE();
			/// Default Ctor 
		HK_FORCE_INLINE Pair() { }
			/// Ctor - set position
		inline Pair( int _x, int _y );
			/// Set the position
		inline void set( int _x, int _y );
			/// Zero the x and y values
		inline void setZero();
			/// Set to p + q
		inline void setAdd( const Pair& p, const Pair& q);
			/// Set to p - q
		inline void setSub( const Pair& p, const Pair& q);
			/// Set to the min(p, q)
		inline void setMin( const Pair& p, const Pair& q);
			/// Set to the max(p, q)
		inline void setMax( const Pair& p, const Pair& q);
			/// Set to the mid(p, q)
		inline void setMid( const Pair& p, const Pair& q);
			/// Add x and y
		inline void add( int _x, int _y );
			/// Add the pair
		inline void add( const Pair& p );
			/// Subtract x and y
		inline void sub( int _x, int _y );
			/// Subtract a pair
		inline void sub( const Pair& p );
			/// Read/write access to element
		inline int& operator[](int i);
			/// Read access to an element
		inline int operator[](int i) const;
			/// Add a pair
		inline void operator+=(const Pair& p);
			/// Subtract a pair
		inline void operator-=(const Pair& p);
			/// ==
		inline hkBool32 operator==(const Pair& p) const;
			/// != 
		inline hkBool32 operator!=(const Pair& p) const;
			/// Pack a pair into a hkUint64
		inline hkUint64 pack() const;
			/// Set the Pair to the unpacked parameter
		inline void unpack(hkUint64 u);

	private:
		int x[2];
	};

		/// 2d integer axis aligned rectangle.
	struct Rectangle
	{
		HK_DECLARE_POD_TYPE();
			/// Default Ctor
		HK_FORCE_INLINE Rectangle() {}
			/// Ctor - initializing with position and size
		inline Rectangle(int _x, int _y, int _w, int _h);
			/// Initialize with size and position 
		inline Rectangle(const Pair& pos, const Pair& size);

			/// Initialize to an invalid rectangle pos (-1, -1) and size (-1, -1)
		inline void init();
			/// ==
		inline hkBool32 operator==( const Rectangle& r ) const;
			/// != 
		inline hkBool32 operator!=( const Rectangle& r ) const;
			/// Returns true if a point is inside the rectangle. 
		inline hkBool contains(const Pair& p ) const;

			/// Returns the rectangle that is the intersection (ie the piece that overlaps) of two rectangles 
			/// If the two rectangles do not intersect, the width and/or height <= 0
		inline Rectangle intersect(const Rectangle& r) const;
			/// Returns true if r overlaps the rectangle 
		inline hkBool overlaps( const Rectangle& r ) const;
			/// Set the rectangle with position and size
		inline void set( int x, int y, int sx, int sy);
			/// Expand to include the given rectangle
		inline void include(const Rectangle& r);
			/// Return the rectangle 'clipped'
		inline Rectangle clipped( int left, int right, int top, int bottom ) const;
			/// The amounts specify how much to move in (towards the center of the box) each 
			/// of the edges. Ie setting left to 1, will move the left edge in by one pixel.
		inline void clip( int left, int right, int top, int bottom );

			/// Return the midpoint
		inline Pair mid() const;
			/// Return a new rectangle shrunk on each side by the dx and dy values
		inline Rectangle shrunk( int dx, int dy ) const;
			/// Shrink the rectangle by dx, and dy. 
			/// Equivalent to pushing or pulling the borders in or out by the delta. 
			/// With positive values will make the rectangle smaller, with negative will make it larger.
		inline void shrink( int dx, int dy );
			/// Shrink using a Pair to specify the deltas
		inline void shrink( const Pair& p );

			/// Move the rectangle by dx, and dy
		inline void move( int dx, int dy );

			/// Calculate the corners of the rectangle in the following order UL, UR, LR, LL
		inline void corners(Pair p[4]) const;
			/// Calculate the area of the rectangle (ie width * height)
		inline int area() const;

		Pair pos;
		Pair size;
	};

	struct Rescaler
	{
		virtual ~Rescaler() {}
		virtual int operator()(int i) const = 0;
	};

	struct FlowLayoutState
	{
		FlowLayoutState() : wrapBits(0) {}
		hkUint64 wrapBits; ///< The i'th bit (from LSB) indicates if a wraped at the i'th child
	};

		/// Internal state needed for text editing.
	struct TextEditState
	{
		TextEditState() : cursorCharIndex(0), overwrite(false) {}
		int cursorCharIndex;
		hkBool overwrite;
	};

		/// Internal state needed for scrolling.
	struct ScrollState
	{
		ScrollState() { curOff = 0; size = 0; inertia = 0; flags = 0; }
			// The scroll offset [0, this.size-page_size]
		int curOff;
			// The size of the scrolled region
		int size;
			// This is the scroll delta (in pixels). It is damped each frame.
		int inertia;
			// Used for cooperation between scrollbar & scrolldrag to indicate which is active.
		int flags;
	};
		/// Internal state for notebooks
	struct NotebookState
	{
		NotebookState() { activePage = 0; }
			/// Index of current page
		int activePage;
			/// For the tab bar on top
		ScrollState scroll;
	};
		/// Widget state bits
	enum WidgetBits
	{
		STATE_NORMAL = 1,		///< Normal
		STATE_MOUSE_HOVER = 2,	///< Mouse over
		STATE_FOCUS = 8,		///< Keyboard input to this widget
		STATE_ACTIVE = 16,		///< Item is "on" or "true" e.g. checkbox checked
		STATE_PRESSED = 32,		///< Item is being pressed (implies pad or mouse pressed)
		STATE_FILL = 64,		///< Background for non-widgets 
		STATE_PAD_PRESSED = 128,///< Item is being pressed
		STATE_MOUSE_PRESSED = 256,///< Item is being pressed

	};
		/// Commonly used directions.
		/// Used for example to tell the painter which direction to draw an arrow.
	enum Direction
	{
		DIR_UP,
		DIR_RIGHT,
		DIR_DOWN,
		DIR_LEFT
	};
		/// Widget state flags
	typedef hkFlags<WidgetBits, int> WidgetFlags;

	struct Painter;
	class Layout;
	struct Context;
}

#include <Graphics/ImGui/ImGui.inl>

#endif // HK_IMGUI_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
