/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

ImGui::Argb ImGui::FlatPainter::Theme::background(WidgetFlags flags) const
{
	if( flags.get(STATE_ACTIVE) )
	{
		return bg_active;
	}
	else if( flags.get(STATE_PRESSED) )
	{
		return bg_pressed;
	}
	else if( flags.get(STATE_MOUSE_HOVER) )
	{
		return bg_hover;
	}
	else if( flags.get(STATE_NORMAL) )
	{
		return bg_widget;
	}
	else if( flags.get(STATE_FILL) )
	{
		return bg_fill;
	}
	return 0xffffff88;
}

ImGui::Argb ImGui::FlatPainter::Theme::foreground(WidgetFlags flags) const
{
	if( flags.get(STATE_ACTIVE) )
	{
		return fg_active;
	}
	else if( flags.get(STATE_PRESSED) )
	{
		return fg_pressed;
	}
	else if( flags.get(STATE_MOUSE_HOVER) )
	{
		return fg_hover;
	}
	else if( flags.get(STATE_NORMAL) )
	{
		return fg_widget;
	}
	else if( flags.get(STATE_FILL) )
	{
		return fg_fill;
	}
	return 0xffffff88;
}

void ImGui::FlatPainter::fillRectangle( const Rectangle& rect, ImGui::Argb color )
{
	m_buffer.fillRectangle(rect,color);
}
void ImGui::FlatPainter::fillTriangle( const Pair& a, const Pair& b, const Pair& c, ImGui::Argb color )
{
	m_buffer.fillTriangle(a,b,c,color);
}
void ImGui::FlatPainter::fillQuad( const Pair& a, const Pair& b, const Pair& c, const Pair& d, ImGui::Argb color )
{
	m_buffer.fillQuad(a,b,c,d,color);
}
void ImGui::FlatPainter::lineQuad( const Pair& a, const Pair& b, const Pair& c, const Pair& d, ImGui::Argb color )
{
	m_buffer.lineQuad(a,b,c,d,color);
}
void ImGui::FlatPainter::lineRectangle( const Rectangle& rect, ImGui::Argb color )
{
	Pair p[4]; rect.corners(p);
	m_buffer.lineQuad(p[0],p[1],p[2],p[3],color);
}
void ImGui::FlatPainter::line( const Pair& a, const Pair& b, ImGui::Argb color )
{
	m_buffer.line(a,b,color);
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
