/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HK_IMGUI_FLAT_PAINTER_H
#define HK_IMGUI_FLAT_PAINTER_H

#include <Graphics/ImGui/ImGuiPainter.h>

namespace ImGui
{
		/// TODO: this is really only used by the default "buffer all draw calls" painter.
	struct RenderMetrics
	{
		virtual ~RenderMetrics();

		virtual int getWindowHeight() = 0;
		virtual int getWindowWidth() = 0;

		virtual int getMaxCharWidth() = 0;
		virtual int getMaxCharHeight() = 0;
		/// For proportional text.
		virtual hkReal measureWidth( int charCode ) = 0;
	};

		/// Paints the GUI using simple flat shaded triangles.
	struct FlatPainter : public Painter
	{
		EXT_SIMPLE_ALLOCATOR();

		struct Theme
		{
			Theme();

			ImGui::Argb bg_fill;
			ImGui::Argb bg_widget;
			ImGui::Argb bg_hover;
			ImGui::Argb bg_pressed;
			ImGui::Argb bg_active;

			ImGui::Argb fg_fill;
			ImGui::Argb fg_widget;
			ImGui::Argb fg_hover;
			ImGui::Argb fg_pressed;
			ImGui::Argb fg_active;

			inline ImGui::Argb background(WidgetFlags flags) const;
			inline ImGui::Argb foreground(WidgetFlags flags) const;
		};

			/// Ctor - takes a RenderMetrics as parameter, used to determine renderings sizes - its in particular for determining text sizes.
		FlatPainter(RenderMetrics* ctx, RenderBuffer& buffer);

			///
		virtual ~FlatPainter();

			/// Return the size of the button, based on the size passed in
		Pair measureButton(const Pair& contents);
			/// Paint a button in the specified rectangle, using the widget flags. Returns the 
			/// inner rectangle - where text can be drawn.
		Rectangle paintButton(const Rectangle& rect, WidgetFlags state);

			/// Create a new texture as a copy of the given buffer.
		const Texture* createTexture( const hkUint32* argb, int w, int h );

			/// Return the size of the image, based on the width and height passed in.	
			/// It may not be the same a width,height if the screen is scaled.
		Pair measureImage(int width, int height);
			/// Paint an image.
		Rectangle paintImage(const Rectangle& rect, const Texture* texture, ImGui::Argb color);

			/// Measure the size of a 'tab' (used for tab icons)
		Pair measureTab(const Pair& contents);
			/// Paint a tab using the specified rect and widget flags. Returns the inner
			/// rectangle - where text can be drawn.
		Rectangle paintTab(const Rectangle& rect, WidgetFlags state);

			/// Measure a notebook for tab height
		virtual Pair measureNotebook(const Pair& contents);
			/// Paint a notebook using the specified rect and widget flags.
		virtual void paintNotebook(const Rectangle& wholeRect, const Pair& tabSize, WidgetFlags state);

			/// Paint a window with specified rect, and widget flags. Returns the inner
			/// window (client area) rectangle.
		Rectangle paintWindow(const Rectangle& window, WidgetFlags state, hkBool hasTitle);
		
			/// Paint a scroll bar
		void paintScrollBar(int axis, const Rectangle& rect, int curPos, int scrolledSize, WidgetFlags state);

			/// Measure the size of a progress bar. 
		Pair measureProgress(int axis, const Pair& child);
			/// Paint the progress bar. Returns inner rectangle of contents area, where 
			/// text can be drawn.
		Rectangle paintProgress(int axis, const Rectangle& rect, hkReal frac);

			/// Measure the size of a spinner.
		Pair measureSpinner(const Pair& child);
			/// Paint a spinner. Returns the rectangle where the contents of the spinner can be drawn.
		Rectangle paintSpinner(const Rectangle& rect, WidgetFlags state);

			/// Measure radio button size
		Pair measureRadio(const char* text) const;
			/// Draw a radio button
		void paintRadio(const Rectangle& rect, const char* text, WidgetFlags flags);

			/// Measure tree
		Pair measureTree( int level, hkBool expandable );
			/// Draw a tree
		void paintTree(const Rectangle& rect, int level, hkBool expandable, hkBool open, WidgetFlags flags);

			/// Measure an expander
		Pair measureExpander( const Pair& child );
			/// Draw an expander. Returns the rectangle where text associated with the expander can be drawn.
		Rectangle paintExpander(const Rectangle& label, const Rectangle& whole, hkBool open, WidgetFlags state);

			/// Measure text and return the size text will take up.
		Pair measureText( const char* text ) const;
			/// Paint text
		void paintTextColor( const Rectangle& pos, const char* text, ImGui::Argb color );
		void paintText( const Rectangle& pos, const char* text, WidgetFlags flags) { paintTextColor(pos,text, m_theme.foreground(flags)); }


			/// Draw a rectangle and fill with specified color.
		inline void fillRectangle( const Rectangle& rect, ImGui::Argb color );
			/// Draw a rectangle with colors at corners in order UL, UR, LR, LL
		inline void fillTriangle( const Pair& a, const Pair& b, const Pair& c, ImGui::Argb color );
			/// Draw a quad filled with the given color
		inline void fillQuad( const Pair& a, const Pair& b, const Pair& c, const Pair& d, ImGui::Argb color );
			/// Draw a hollow quad with the given color
		inline void lineQuad( const Pair& a, const Pair& b, const Pair& c, const Pair& d, ImGui::Argb color );
			/// Draw a hollow rectangle with the given color
		inline void lineRectangle( const Rectangle& rect, ImGui::Argb color );
			/// Draw a line with the given color
		inline void line( const Pair& a, const Pair& b, ImGui::Argb color );


			/// Draw a highlight		
		void highlight(const Rectangle& rect, hkUint32 argb=0);

			/// Gets the maximum character width
		int getMaxCharWidth() const;
			/// Get the maximum character height
		int getMaxCharHeight() const;
			/// Calculate the index in the text most appropriate for the pixel offset, from the start of the text
		int charIndexFromOffset( const char* text, int off) const;

			/// Get the current clip rectangle.
		const Rectangle& getClipRect() const;
			/// Push a new clip rectangle.
			/// The rectangle overwrites the clip area - it is not intersected.
		void pushClipRect(const Rectangle& inner);

			/// Pop the clipstack and return current clip region.
		Rectangle popClipRect();
			/// Use the z buffer to handle drawing overlaps
		void adjustDepth(int factor);

	public:

		void _paintTriangle(const Rectangle& r, Direction direction, ImGui::Argb color);
		void _wireChevron(const Rectangle& r, Direction direction, ImGui::Argb color);

		int m_winWidth;
		int m_winHeight;
		Pair m_charSize; 
		Pair m_border; 

		RenderBuffer& m_buffer;
		RenderMetrics* m_renderer;
		Theme m_theme;
	};
}

#include <Graphics/ImGui/FlatPainter/ImGuiFlatPainter.inl>

#endif // HK_IMGUI_FLAT_PAINTER_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
