/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_VERTEX_SET_DX9S_H
#define HK_GRAPHICS_VERTEX_SET_DX9S_H

#include <Graphics/Common/Geometry/VertexSet/hkgVertexSet.h>

class hkgVertexSetDX9S : public hkgVertexSet
{
public:

	static hkgVertexSet* createVertexSetDX9S( hkgDisplayContext* context)
	{
		return new hkgVertexSetDX9S( context);
	}	

	virtual ~hkgVertexSetDX9S();

	virtual void advanceToFrame(int frameId);

	virtual void setDesiredVertexComponentFormat( HKG_VERTEX_COMPONENT component, HKG_VERTEX_STORAGE s);
	virtual void setDesiredVertexComponentLayout( HKG_VERTEX_STORAGE_LAYOUT l);  
	virtual HKG_VERTEX_STORAGE_LAYOUT hkgVertexSetDX9S::getVertexComponentLayout( ) const;
	
	virtual void setNumVerts(int nv, HKG_VERTEX_FORMAT format, HKG_VERTEX_BUFFER_ACCESS accessFlags = HKG_VERTEX_BUFFER_ACCESS_DEFAULT);

	virtual unsigned char* lock(HKG_LOCK_FLAG f );  
	virtual unsigned char* partialLock(HKG_LOCK_FLAG f, HKG_VERTEX_FORMAT vertexFormatPartsToLock);
	virtual void unlock();

	virtual int getVertexComponentStream( HKG_VERTEX_COMPONENT component ) const;
	virtual int getVertexComponentStreamOffset( HKG_VERTEX_COMPONENT component ) const;

		/// Set the client pointers / stream pointers to this data. Passed the current 
		/// enabled streams so that it can match what it needs.
	virtual void setStreams(); 
	virtual void clearStreams(); 

	inline bool isBufferInHardware() const; 

	void invalidateVB();
	void restoreVB();

protected:

	hkgVertexSetDX9S( hkgDisplayContext* context);

	HKG_VERTEX_STORAGE_LAYOUT m_desiredLayout;
	HKG_VERTEX_STORAGE	m_desiredStorageFormats[HKG_VERTEX_COMPONENT_NUM]; // the format of each vert component

	struct BufferInfo
	{
		BufferInfo() : m_localBuffer(HK_NULL), m_stride(0), m_aligned(false), m_frequentAccess(false), m_mappedBuffer(HK_NULL), m_localUpdate(false), m_lockedBufIndex(0) { m_vb[0] = HK_NULL; m_vb[1] = HK_NULL; }
		
		unsigned char* m_localBuffer;

		LPDIRECT3DVERTEXBUFFER9 m_vb[2];
		int m_stride;
		bool m_aligned;
		bool m_frequentAccess;

		unsigned char* m_mappedBuffer;
		bool m_localUpdate;

		int m_lockedBufIndex;
	};

	extArray< BufferInfo > m_buffers;	
	
	int m_componentBufferIndex[HKG_VERTEX_COMPONENT_NUM]; 
	hkUlong	m_bufferOffsets[HKG_VERTEX_COMPONENT_NUM];

	LPDIRECT3DVERTEXDECLARATION9	m_pVertexDeclaration;			// Vertex declaration for shaders
	LPDIRECT3DVERTEXDECLARATION9	m_pInstancedVertexDeclaration;  // Vertex declaration for shaders that want the instanced transform vb
	LPDIRECT3DVERTEXDECLARATION9	m_pVertexPrevDeclaration;		// Vertex declaration for shaders that want the prev dynamic vb too
	
	int m_maxHardwareBlendMatrices;
	bool m_hardwareVB;

	int m_currentFrameId;
	int m_currentPosVbIndex;
};

#include <Graphics/Dx9s/Shared/Geometry/VertexSet/hkgVertexSetDX9S.inl>

#endif //HK_GRAPHICS_VERTEX_SET_DX9S_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
