/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_FACE_SET_DX9S_H
#define HK_GRAPHICS_FACE_SET_DX9S_H

#include <Graphics/Common/Geometry/FaceSet/hkgFaceSet.h>
#include <Graphics/Dx9s/Shared/DisplayContext/hkgDisplayContextDX9S.h>

class hkgFaceSetDX9S : public hkgFaceSet
{
public:

	static hkgFaceSet* createFaceSetDX9S(hkgDisplayContext* context)
	{
		return new hkgFaceSetDX9S(context);
	}	

	virtual bool supportsLargeIndices() const;

	void render(hkgDisplayContext* context);

	// psuedo Instanced cpu style rendering
	void renderSetState(hkgDisplayContext* state);
	void renderPrims(hkgDisplayContext* state);
	void renderSinglePrim(hkgDisplayContext* state, int pi, hkgBlendMatrixSet* overrideBm );
	void renderCleanState(hkgDisplayContext* state);

	inline LPDIRECT3DDEVICE9 getDevice();
	inline const LPDIRECT3DDEVICE9 getDevice() const;

	virtual void initialize(extArray<hkUint32>* reorderedVertices = HK_NULL);
	virtual void reinitialize();

public:

	int	 m_numIndexedPrimsThisFrame;

protected:
		
	hkgFaceSetDX9S(hkgDisplayContext* context);
	virtual ~hkgFaceSetDX9S();

	void createIndexBuffer(bool newIndexBuffer);

	hkgDisplayContext* m_context;
	LPDIRECT3DDEVICE9		m_device;
	LPDIRECT3DINDEXBUFFER9	m_pIB;
	bool					m_hardwareIB;
	bool					m_largeIndexSupport;
	unsigned int			m_numIndices;


	struct IndexBufferInfo
	{
		unsigned int minIndex;
		unsigned int startIndex;
		unsigned int rangeSize;
	};

	extArray<IndexBufferInfo> m_connectionInfo;
};

#include <Graphics/Dx9s/Shared/Geometry/FaceSet/hkgFaceSetDX9S.inl>

#endif // HK_GRAPHICS_FACE_SET_DX9S_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
