/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_BLEND_MATRIX_SET_DX9S
#define HK_GRAPHICS_BLEND_MATRIX_SET_DX9S

#include <Graphics/Common/Geometry/BlendMatrixSet/hkgBlendMatrixSet.h>

/// A class to represent a group of matrices used for blending
class hkgBlendMatrixSetDX9S : public hkgBlendMatrixSet
{
public:
	
	static hkgBlendMatrixSet* createBlendMatrixSetDX9S(hkgDisplayContext* context)
	{
		return new hkgBlendMatrixSetDX9S(context);
	}	

	virtual int getNumMatrices() const { return m_matrices.getSize(); }

	virtual void addMatrix(const float* m, int referenceID);

	virtual void setMatrix(int i, const float* m);
	virtual void setMatrixAligned( int i, const hkTransform& mat);

	virtual const float* getMatrix(int i) const { return &(m_matrices[i].m[0][0]); }

	virtual bool bind();	

	virtual void clear() { m_matrices.setSize(0); m_referenceIDs.setSize(0); }

protected:

	hkgBlendMatrixSetDX9S(hkgDisplayContext* context);

	hkgDisplayContext* m_context;
	extArray<D3DMATRIX> m_matrices;
	int m_maxMatrices;

};

#endif // HK_GRAPHICS_BLEND_MATRIX_SET_DX9S

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
