/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_DISPLAY_CONTEXT_DX9S_H
#define HK_GRAPHICS_DISPLAY_CONTEXT_DX9S_H

#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>
#include <Graphics/Dx9s/Shared/Window/hkgWindowDX9S.h>

inline void hkgConditionXboxFileName(const char* in, extStringBuf& out)
{
	extStringBuf p(in);
	
	p.replace('/', '\\');
	int properStart = 0;
	while ( (p[properStart] == '.') || (p[properStart] == '\\'))
	{
		properStart++;
	}
	p.chompStart(properStart);
	// might start with D already, or some other Xbox drive or cache name, if not, add D:
	if( p.indexOf(':') == -1)
	{
		p.prepend("D:\\");
	}

	out = p;
}

class hkgDisplayContextDX9S : public hkgDisplayContext
{
public:

	static hkgDisplayContext* createDisplayContextDX9S(hkgWindow* owner)
	{
		return new hkgDisplayContextDX9S(owner);
	}
	
	virtual void setLightingState(bool on);
	virtual void setTexture2DState(bool on);
	virtual void setBlendState(bool on);
	virtual void setDepthReadState(bool on);
	virtual void setDepthWriteState(bool on);
	virtual void setCullFaceState(bool on);
	virtual void setWireframeState(bool on);
	virtual void setDepthBias(float offset);
	virtual void setLightState(int light, bool on);
	virtual void setScissorState(bool on);

	virtual void setScissorRect(int ll_x, int ll_y, int ur_x, int ur_y );

	virtual void popMatrix();
	virtual void pushMatrix();
	virtual void multMatrix( const float* m);
	virtual void beginGroup(HKG_IMM_GROUP type);
	virtual void  setCurrentColor3( const float* c);
	virtual void  setCurrentColor4( const float* c);
	virtual void  setCurrentColorPacked( unsigned int c);
	virtual void  setCurrentTextureCoord(const float* uv);
	virtual void  setCurrentNormal(const float* n);
	virtual void  setCurrentPosition(const float* p);
	virtual void endGroup(bool useCurrentShaders = false);
	virtual void flush();

	inline LPDIRECT3DDEVICE9 getDevice();
	inline const LPDIRECT3DDEVICE9 getDevice() const;

	void initD3DState(); //needs to be called not only on ctor, but also after device::Reset()

	virtual hkgShaderEffectCollection* getDefaultShaderEffectCollection() const;
	void setDefaultShaderEffectCollection(hkgShaderEffectCollection* c);

	virtual hkgShaderEffectCollection* getCurrentGlobalShaderEffectCollection( ) const;

	virtual void lock() const;

	virtual void unlock() const;

	void invalidateDynamicTextures();
	void restoreDynamicTextures();

protected:

	hkgDisplayContextDX9S(hkgWindow* owner); 
	virtual ~hkgDisplayContextDX9S();
	
	void computeRenderCaps(hkgRenderCaps& c) const;

	struct VertInfo
	{
		HKG_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( VertInfo );

		float x,y,z;
		float nx, ny, nz; 
		DWORD c;
		float tu, tv;
	};

	HKG_IMM_GROUP		m_immMode;
	extArray<VertInfo>	m_immVerts; 
	bool				m_immGroup;
	extArray<float>		m_matrixStack;  // every 16 floats == matrix. 
	float				m_curNorm[3];
	float				m_curUV[2];
	DWORD				m_curColor;

	int					m_lastLockImmVert;
	LPDIRECT3DDEVICE9	m_device;
	LPDIRECT3DVERTEXBUFFER9	m_pVB;		// a large vb to hold our imm lines etc. We can't use DrawPrumUP on some consoles.
	LPDIRECT3DVERTEXDECLARATION9	m_pVertexDeclaration;      // Vertex declaration for shaders
	
	hkgShaderEffectCollection* m_defaultCollection; // a set of standard vs/ps pairs for this dx9 platform
};

#include <Graphics/Dx9s/Shared/DisplayContext/hkgDisplayContextDX9S.inl>

#endif //HK_GRAPHICS_DISPLAY_CONTEXT_DX9S_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
