/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_CAMERA_DX9S_H
#define HK_GRAPHICS_CAMERA_DX9S_H

#include <Graphics/Common/Camera/hkgCamera.h>

class hkgCameraDX9S : public hkgCamera
{
public:

	static hkgCamera* createCameraDX9S();	

	virtual void setAsCurrent(hkgDisplayContext* state);

	virtual float* getPlatformViewMatrix() { computeViewMatrixDX(); return m_platformView; }
	virtual float* getPlatformProjectionMatrix() { computeProjMatrixDX(); return m_platformProj; }
	
	static void setMatrices( hkgDisplayContext* state, const float* view, const float* proj, const float* prevViewProj );

protected:

	void computeViewMatrixDX();
	void computeProjMatrixDX();

	inline hkgCameraDX9S( const float* from, const float* to, const float* up, float fov);
	virtual ~hkgCameraDX9S() {}

	float m_platformView[16];
	float m_platformProj[16];
};

#include <Graphics/Dx9s/Shared/Camera/hkgCameraDX9S.inl>

#endif // HK_GRAPHICS_CAMERA_DX9S_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
