/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_WINDOW_DX9S_PC_H
#define HK_GRAPHICS_WINDOW_DX9S_PC_H

#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Dx9s/Shared/Window/hkgWindowDX9S.h>

//-----------------------------------------------------------------------------
// Error codes
//-----------------------------------------------------------------------------
typedef unsigned short APPMSGTYPE;
#define MSG_NONE 0
#define MSGERR_APPMUSTEXIT 1
#define MSGWARN_SWITCHEDTOREF 2

#define D3DAPPERR_NODIRECT3D          0x82000001
#define D3DAPPERR_NOWINDOW            0x82000002
#define D3DAPPERR_NOCOMPATIBLEDEVICES 0x82000003
#define D3DAPPERR_NOWINDOWABLEDEVICES 0x82000004
#define D3DAPPERR_NOHARDWAREDEVICE    0x82000005
#define D3DAPPERR_HALNOTCOMPATIBLE    0x82000006
#define D3DAPPERR_NOWINDOWEDHAL       0x82000007
#define D3DAPPERR_NODESKTOPHAL        0x82000008
#define D3DAPPERR_NOHALTHISMODE       0x82000009
#define D3DAPPERR_NONZEROREFCOUNT     0x8200000a
#define D3DAPPERR_MEDIANOTFOUND       0x8200000b
#define D3DAPPERR_RESIZEFAILED        0x8200000c
#define D3DAPPERR_NULLREFDEVICE       0x8200000d



struct D3DModeInfo9
{
    DWORD      Width;      // Screen width in this mode
    DWORD      Height;     // Screen height in this mode
    D3DFORMAT  Format;     // Pixel format in this mode
    DWORD      dwBehavior; // Hardware / Software / Mixed vertex processing
    D3DFORMAT  DepthStencilFormat; // Which depth/stencil format to use with this mode
};

struct D3DDeviceInfo9
{
    // Device data
    D3DDEVTYPE   DeviceType;      // Reference, HAL, etc.
    D3DCAPS9     d3dCaps;         // Capabilities of this device
    const TCHAR* strDesc;         // Name of this device
    BOOL         bCanDoWindowed;  // Whether this device can work in windowed mode

    // Modes for this device
    DWORD        dwNumModes;
    D3DModeInfo9  modes[150];

    // Current state
    DWORD        dwCurrentMode;
    BOOL         bWindowed;
    D3DMULTISAMPLE_TYPE MultiSampleTypeWindowed;
    D3DMULTISAMPLE_TYPE MultiSampleTypeFullscreen;
};

struct D3DAdapterInfo9
{
    // Adapter data
    D3DADAPTER_IDENTIFIER9 d3dAdapterIdentifier;
    D3DDISPLAYMODE d3ddmDesktop;      // Desktop display mode for this adapter

    // Devices for this adapter
    DWORD          dwNumDevices;
    D3DDeviceInfo9  devices[5];

    // Current state
    DWORD          dwCurrentDevice;
};

class hkgDirectJoystickPC9S;

class hkgXInputPadPC9S;

class hkgWindowDX9SPC : public hkgWindowDX9S
{
public:

	static hkgWindow* createWindowDX9SPC();
	
	virtual bool initialize( HKG_WINDOW_CREATE_FLAG flags, HKG_WINDOW_BUFFERS buffers, int w, int h, const char* name, void* windowHandle = HK_NULL, void* parentHandle = HK_NULL ); // returns success
	virtual bool initializeContext();
	virtual void cleanup();

	virtual HKG_WINDOW_DX9S_OPERATING_SYSTEM getOperatingSystem() const;

	virtual int getVideoMemSizeInMB() const;

	virtual	bool setAsCurrent(); // only need to call this if you have > 1 window
	virtual bool clearBuffers();
	virtual bool swapBuffers();

	virtual bool updateSize( unsigned int w, unsigned int h);
	virtual bool updatePos( unsigned int x, unsigned int y);

	virtual void setMousePosition(int x,int y);
	virtual void showMouseCursor(bool visible);

	virtual HKG_WINDOW_MSG_STATUS peekMessages(bool inViewportResize = false); // will loop on windows messages if any. Will return if idle.
	virtual void waitMessages(); // block until there is messages

	inline HINSTANCE getInstanceHandle() const;

	virtual bool hasGamePads() const { return (getConnectedPads() != HKG_PAD_CONNECTED_NONE); }
	virtual HKG_PAD_CONNECTED_MASK getConnectedPads() const;

	/// Set gamepad vibration strength if supported. (Currently only supported for Xbox360 
	/// style controllers under DX9S). 
	virtual void setGamePadVibrationState(int pad, hkUint16 lowFrequencyStrength, hkUint16 highFrequencyStrength);

	virtual int getDisplayAdapter() const { return m_dwAdapter; }

	inline bool getActiveState() const;
	inline void setActiveState(bool a);
	
	// Internal
	virtual bool updateGamePads();
	virtual void disableGamePads();
	virtual void enableGamePads();


	
protected:

	hkgWindowDX9SPC( HINSTANCE instance, WORD menuID = 0);
	virtual ~hkgWindowDX9SPC();

	HRESULT					initializeD3D();
	void					cleanupD3D();
	HRESULT					resizeD3D();
	bool					updateSizeD3D(bool forceReset = false);

	HRESULT					buildDeviceList(int w, int h, HKG_WINDOW_CREATE_FLAG flags);
	

	extArray<D3DAdapterInfo9>	m_Adapters;
    DWORD					m_dwNumAdapters;
    DWORD					m_dwAdapter;
	mutable int				m_videoRamSize;

	DWORD					m_dwWindowStyle;     // Saved window style for mode switches
    RECT					m_rcWindowBounds;    // Saved window bounds for mode switches
    RECT					m_rcWindowClient;    // Saved client area size for mode switches
	
	BOOL					m_bUseDepthBuffer;   // Whether to autocreate depthbuffer
    DWORD					m_dwMinDepthBits;    // Minimum number of bits needed in depth buffer
    DWORD					m_dwMinStencilBits;  // Minimum number of bits needed in stencil buffer
 
	D3DSURFACE_DESC			m_d3dsdBackBuffer;   // Surface desc of the backbuffer
    char					m_strDeviceStats[90];// String to hold D3D device stats
  

	BOOL					findDepthStencilFormat(	UINT iAdapter, D3DDEVTYPE DeviceType, D3DFORMAT TargetFormat, D3DFORMAT* pDepthStencilFormat );
	HRESULT					userSelectNewDevice();

	HRESULT					toggleFullscreen();
	HRESULT					forceWindowed();
	HRESULT					adjustWindowForChange();

	HRESULT 				displayErrorMsg( HRESULT hr, DWORD dwType );

	HRESULT ConfirmDevice(D3DCAPS9*,DWORD,D3DFORMAT)   { return S_OK; }
    HRESULT OneTimeSceneInit()                         { return S_OK; }
    HRESULT InitDeviceObjects()                        { return S_OK; }
    HRESULT RestoreDeviceObjects();                    
    HRESULT InvalidateDeviceObjects();
    HRESULT DeleteDeviceObjects()                      { return S_OK; }

	HINSTANCE				m_hinstance;

	bool					m_ownHWND; // did it create the hwnd?

	hkgDirectJoystickPC9S*	m_directJoysticks[4];
	hkgXInputPadPC9S*		m_xinputPads[4];
						
};

// WndProc prototype
LRESULT CALLBACK hkgWindowProcDX9SPC(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

#include <Graphics/Dx9s/Pc/Window/hkgWindowDX9SPC.inl>

#endif //HK_GRAPHICS_WINDOW_DX9S_PC_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
