/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_DX11_PRECOMPILE_H
#define HK_GRAPHICS_DX11_PRECOMPILE_H

#include <Common/Base/hkBase.h>

#if !defined(HK_PLATFORM_WINRT) && !defined(HK_PLATFORM_DURANGO)

#ifndef _WINDOWS_
#define STRICT 1
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#endif

#undef _WIN32_WINNT
#	define _WIN32_WINNT 0x0500	 // win2000

#undef _WIN32_WINDOWS 
#define _WIN32_WINDOWS _WIN32_WINNT // win2000
#undef WINVER	
#define WINVER _WIN32_WINNT	      // win2000

//#define DIRECT3D_VERSION         0x0900
//#define DIRECTINPUT_VERSION		 0x0800
#include <windows.h>
#endif // ifndef _WINDOWS_

#pragma warning(disable:4005)

#include <d3d11.h>

#define HKG_DX11_0 1
#if (_MSC_VER < 1700) || defined(HKG_LEGACY_DIRECTX)
  #include <d3dx11.h>
  #define HKG_DX11_SUPPORTS_D3DX 1
#endif
#define _D3D11Device ID3D11Device
#define _D3D11DeviceContext ID3D11DeviceContext

#define HKG_DX11_SUPPORT_RUNTIMECOMPILER 1

#else // WinRT / newer DX11.x style

#	define HKG_DX11_METRO_STYLE 1
#	define HKG_DX11_METRO_STYLE 1
#	if defined(HK_PLATFORM_DURANGO)
#		include <xdk.h>
#	endif
#	if defined(HK_PLATFORM_DURANGO) && (_XDK_VER >= 11064)
#		include <d3d11_x.h>
#	else
#		include <d3d11_1.h>
#		include <dxgi1_2.h>
#	endif
#   define HKG_DX11_1 1 
#	define _D3D11Device ID3D11Device1
#	define _D3D11DeviceContext ID3D11DeviceContext1
#	if !defined(WINAPI_FAMILY) || (WINAPI_FAMILY != WINAPI_FAMILY_PHONE_APP)
#		define HKG_DX11_SUPPORT_ABOVE_93 
#	endif
//#	if defined(HK_PLATFORM_DURANGO) 
//#		define HKG_DX11_SUPPORT_RUNTIMECOMPILER 1
//#	endif
#	if !defined(WINAPI_FAMILY)
#	    define HKG_DX11_SUPPORT_RUNTIMECOMPILER // we do for now to aid testing
#	endif
#endif

#ifdef HKG_DX11_SUPPORT_RUNTIMECOMPILER // will be more defined here.
#	include <D3Dcompiler.h>
#endif

#ifdef _DURANGO
	#define D3D10_SHADER_MACRO D3D_SHADER_MACRO
	#define D3D10Include D3DInclude
	#define LPD3D10INCLUDE LPD3DINCLUDE
	#define ID3D10Include ID3DInclude
	#define D3D10_INCLUDE_TYPE D3D_INCLUDE_TYPE
	//#define D3D10_SHADER_ENABLE_BACKWARDS_COMPATIBILITY 0
#endif

#if !defined(WINAPI_FAMILY) || (WINAPI_FAMILY != WINAPI_FAMILY_PHONE_APP)
#	define HKG_DX11_SUPPORT_ABOVE_FEATURE_LEVEL_93
#	ifndef HK_PLATFORM_DURANGO
#		define HKG_DX11_SUPPORTS_XINPUT 
#		define HKG_DX11_SUPPORTS_WINCODEC
#		include <xinput.h>
#	endif
#endif

#include <Graphics/Common/hkGraphics.h> // the source header for the hkg precompiles

#if defined(HKG_DX11_SUPPORT_RUNTIMECOMPILER) && defined(HKG_DX11_SUPPORTS_D3DX)
#define HKG_DX11_SUPPORTS_EFFECTSLIB 1
#endif


#define DX_SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }

#endif //HK_GRAPHICS_DX11_PRECOMPILE_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
