/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

inline const void hkgWindowDX11::getDisplayAdapterDesc( DXGI_ADAPTER_DESC& desc ) const
{
	if (m_adapter)
	{
		m_adapter->GetDesc(&desc); 
	}
}

inline const _D3D11Device* hkgWindowDX11::getDevice() const
{
	return m_device;
}

inline _D3D11Device* hkgWindowDX11::getDevice()
{
	return m_device;
}

inline const IDXGISwapChain* hkgWindowDX11::getSwapChain() const
{
	return m_swapChain;
}

inline IDXGISwapChain* hkgWindowDX11::getSwapChain()
{
	return m_swapChain;
}

inline const ID3D11RenderTargetView* hkgWindowDX11::getRenderTargetView() const
{
	return m_renderTargetView;
}

inline ID3D11RenderTargetView* hkgWindowDX11::getRenderTargetView()
{
	return m_renderTargetView;
}

inline const ID3D11Texture2D* hkgWindowDX11::getDepthStencil() const
{
	return m_depthStencil;
}

inline ID3D11Texture2D* hkgWindowDX11::getDepthStencil()
{
	return m_depthStencil;
}

inline const ID3D11DepthStencilView* hkgWindowDX11::getDepthStencilView() const
{
	return m_depthStencilView;
}

inline ID3D11DepthStencilView* hkgWindowDX11::getDepthStencilView()
{
	return m_depthStencilView;
}

inline int hkgWindowDX11::getRenderTargetWidth() const
{
	#ifdef HKG_DX11_1
		return m_swapChainDesc.Width;
	#else
		return m_swapChainDesc.BufferDesc.Width;
	#endif
}

inline int hkgWindowDX11::getRenderTargetHeight() const
{
	#ifdef HKG_DX11_1
		return m_swapChainDesc.Height;
	#else
		return m_swapChainDesc.BufferDesc.Height;
	#endif
}

inline DXGI_FORMAT hkgWindowDX11::getRenderTargetFormat() const
{
	#ifdef HKG_DX11_1
		return m_swapChainDesc.Format; 
	#else
		return m_swapChainDesc.BufferDesc.Format;
	#endif
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
