/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_WINDOW_DX11_H
#define HK_GRAPHICS_WINDOW_DX11_H

#include <Graphics/Common/Window/hkgWindow.h>

// we make all explicit DLL calls as function ptrs so 
// that we cvan dynamically load the dll (if present)
// and handle when it is missing and also simplifiy
// the includes required for the exe.

#ifndef HKG_DX11_METRO_STYLE

typedef HRESULT (WINAPI *__CreateDXGIFactoryFUNC)( REFIID riid, void **ppFactory );

// CORE:
typedef HRESULT (WINAPI *_D3D11CreateDeviceAndSwapChainFUNC)(
  IDXGIAdapter *pAdapter,
  D3D_DRIVER_TYPE DriverType,
  HMODULE Software,
  UINT Flags,
  CONST D3D_FEATURE_LEVEL *pFeatureLevels,
  UINT FeatureLevels,
  UINT SDKVersion,
  CONST DXGI_SWAP_CHAIN_DESC *pSwapChainDesc,
  IDXGISwapChain **ppSwapChain,
  _D3D11Device **ppDevice,
  D3D_FEATURE_LEVEL *pFeatureLevel,
  _D3D11DeviceContext **ppImmediateContext
);

#if HKG_DX11_SUPPORTS_D3DX==1
// D3DX:
typedef HRESULT (WINAPI *_D3DX11CreateTextureFromMemoryFUNC)(
  _D3D11Device *pDevice,
  LPCVOID pSrcData,
  SIZE_T SrcDataSize,
  D3DX11_IMAGE_LOAD_INFO *pLoadInfo,
  ID3DX11ThreadPump *pPump,
  ID3D11Resource **ppTexture,
  HRESULT *pHResult
);

typedef HRESULT (WINAPI *_D3DX11CompileFromFileFUNC)(
  LPCSTR pSrcFile,
  CONST D3D10_SHADER_MACRO *pDefines,
  LPD3D10INCLUDE pInclude,
  LPCSTR pFunctionName,
  LPCSTR pProfile,
  UINT Flags1,
  UINT Flags2,
  ID3DX11ThreadPump *pPump,
  ID3DBlob **ppShader,
  ID3DBlob **ppErrorMsgs,
  HRESULT *pHResult
);

typedef HRESULT (WINAPI *_D3DX11CompileFromMemoryFUNC)(
  LPCSTR pSrcData,
  SIZE_T SrcDataLen,
  LPCSTR pFileName,
  CONST D3D10_SHADER_MACRO *pDefines,
  LPD3D10INCLUDE pInclude,
  LPCSTR pFunctionName,
  LPCSTR pProfile,
  UINT Flags1,
  UINT Flags2,
  ID3DX11ThreadPump *pPump,
  ID3DBlob **ppShader,
  ID3DBlob **ppErrorMsgs,
  HRESULT *pHResult
	);

typedef HRESULT (WINAPI *_D3DX11GetImageInfoFromMemoryFUNC)(
	LPCVOID                   pSrcData,
	SIZE_T                    SrcDataSize,
	ID3DX11ThreadPump*        pPump,
	D3DX11_IMAGE_INFO*        pSrcInfo,
	HRESULT*                  pHResult);

#endif

#define D3D_SHADER_MACRO D3D10_SHADER_MACRO
#define D3D_SHADER_INCLUDE ID3D10Include
#else
//#define D3D_SHADER_MACRO already
#define D3D_SHADER_INCLUDE ID3DInclude

#endif


// D3DCOMPILE
typedef HRESULT (WINAPI *_D3DReflectFUNC)(
	LPCVOID pSrcData,
    SIZE_T SrcDataSize,
    REFIID pInterface,
    void** ppReflector);

typedef HRESULT (WINAPI *_D3DCompileFUNC)(
  LPCVOID pSrcData,
  SIZE_T SrcDataSize,
  LPCSTR pSourceName,
  CONST D3D_SHADER_MACRO *pDefines,
  D3D_SHADER_INCLUDE* pInclude,
  LPCSTR pEntrypoint,
  LPCSTR pTarget,
  UINT Flags1,
  UINT Flags2,
  LPD3D10BLOB *ppCode,
  LPD3D10BLOB *ppErrorMsgs );

typedef HRESULT (WINAPI *_D3DCompileFromFileFUNC)(
  LPCWSTR pFileName,
  CONST D3D_SHADER_MACRO* pDefines,
  D3D_SHADER_INCLUDE* pInclude,
  LPCSTR pEntrypoint,
  LPCSTR pTarget,
  UINT Flags1,
  UINT Flags2,
  LPD3D10BLOB* ppCode,
  LPD3D10BLOB* ppErrorMsgs);

typedef HRESULT (WINAPI *_D3DGetInputSignatureBlobFUNC)(
	LPCVOID pSrcData,
    SIZE_T SrcDataSize,
    LPD3DBLOB* ppSignatureBlob);

#ifndef HKG_DX11_METRO_STYLE
extern __CreateDXGIFactoryFUNC __CreateDXGIFactory;
extern _D3D11CreateDeviceAndSwapChainFUNC _D3D11CreateDeviceAndSwapChain;
#if HKG_DX11_SUPPORTS_D3DX==1
  extern _D3DX11CreateTextureFromMemoryFUNC _D3DX11CreateTextureFromMemory;
  extern _D3DX11CompileFromFileFUNC _D3DX11CompileFromFile;
  extern _D3DX11CompileFromMemoryFUNC _D3DX11CompileFromMemory;
  extern _D3DX11GetImageInfoFromMemoryFUNC _D3DX11GetImageInfoFromMemory;
#endif // d3dx
#endif

extern _D3DReflectFUNC _D3DReflect;
extern _D3DCompileFUNC _D3DCompile;
extern _D3DCompileFromFileFUNC _D3DCompileFromFile;
extern _D3DGetInputSignatureBlobFUNC _D3DGetInputSignatureBlob;

// XInput
#ifdef HKG_DX11_SUPPORTS_XINPUT
typedef void  (WINAPI * ___XInputEnableFUNC)( BOOL enable);
typedef DWORD (WINAPI * ___XInputGetStateFUNC)( DWORD dwUserIndex, struct _XINPUT_STATE* pState);
typedef DWORD (WINAPI * ___XInputSetStateFUNC)( DWORD dwUserIndex, struct _XINPUT_VIBRATION* pVibration);
typedef DWORD (WINAPI * ___XInputGetCapabilitiesFUNC)( DWORD dwUserIndex,	DWORD dwFlags, struct _XINPUT_CAPABILITIES* pCapabilities);
extern ___XInputEnableFUNC			___XInputEnable;
extern ___XInputGetStateFUNC		___XInputGetState;
extern ___XInputSetStateFUNC		___XInputSetState;
extern ___XInputGetCapabilitiesFUNC	___XInputGetCapabilities;
#endif


#define HKG_DX11_DEFAULT_SHADOWMAP_SIZE 512 
#define HKG_DX11_NUM_KNOWN_RENDERTARGETS 8

#define HKG_DX11_SHARED_SAMPLER_SLOT  0
#define HKG_DX11_CLAMPED_SAMPLER_SLOT 1
#define HKG_DX11_SHADOW_SAMPLER_SLOT 2

struct ReverseDepthPeelData;

typedef hkUint32 HKG_DX11_FEATURE_LEVEL;
#define HKG_DX11_FEATURE_LEVEL_9_1  0x9100
#define HKG_DX11_FEATURE_LEVEL_9_2  0x9200
#define HKG_DX11_FEATURE_LEVEL_9_3  0x9300
#define HKG_DX11_FEATURE_LEVEL_10_0 0xa000
#define HKG_DX11_FEATURE_LEVEL_10_1 0xa100
#define HKG_DX11_FEATURE_LEVEL_11_0 0xb000
#define HKG_DX11_FEATURE_LEVEL_11_1 0xb100

extern HKG_DX11_FEATURE_LEVEL g_hkgMaxFeatureLevel;


class hkgWindowDX11ResetEventHandler
{
public:

	virtual void releaseD3D11() = 0;
	virtual void resetD3D11() = 0;
};

class hkgWindowDX11 : public hkgWindow
{
public:

	virtual void cleanup();

	inline const _D3D11Device* getDevice() const;
	inline _D3D11Device* getDevice();
	inline const IDXGISwapChain* getSwapChain() const;
	inline IDXGISwapChain* getSwapChain();
	inline const ID3D11RenderTargetView* getRenderTargetView() const;
	inline ID3D11RenderTargetView* getRenderTargetView();
	inline const ID3D11Texture2D* getDepthStencil() const;
	inline ID3D11Texture2D* getDepthStencil();
	inline const ID3D11DepthStencilView* getDepthStencilView() const;
	inline ID3D11DepthStencilView* getDepthStencilView();

	virtual HKG_SHADOWMAP_SUPPORT getShadowMapSupport();
	virtual void prepareForShadowMap(int maxMaps); // creates depth and render target
	virtual void beginShadowMapRender(class hkgDisplayWorld* world, class hkgCamera* camera, class hkgLight* light  ); // sets the depth and render target to be the current
	virtual const class hkgCamera* startShadowMap( int ss, bool clearMap ); // returns the light frustum which is being used to render
	virtual void endShadowMap( int ss, bool blurMap);
	virtual int endShadowMapRender(int textureStageForMap, bool shaderDriven); // resets to the normal depth and render target
	virtual void revertShadowMapState(); // resets to the normal texture modes etc
	virtual void cleanupShadowMap(); // releases held targets
	virtual void setShadowMapSize(int size); 
	virtual int getShadowMapSize() const;
	virtual void enableDebugShadowMapView(bool on) const { m_debugShadowMaps = on; } 
	virtual void setShadowMapSplits( int numSplits );  // if in PSVSM mode, then this will govern the number of maps to use. Otherwise it will do nothing. 1 Split == 2 maps, 2 Splits == 3 maps. Each map can be a separate additional pass on top of the render pass.

	virtual void renderOIT( hkgDisplayObject** alphaObjects, int numObjects ) const;
	void prepareForOIT() const;
	void cleanupOIT();
	
	void setShadowMapQuality( HKG_SHADOWMAP_QUALITY q );
	HKG_SHADOWMAP_QUALITY getShadowMapQuality();

	virtual const float* getComputedShadowMatrix(bool includeCameraViewMatrix, int i) const; // get the perspective shadow matrix
	virtual const float* getComputedShadowTextureMatrix(bool includeCameraViewMatrix, int i) const; // get the perspective shadow matrix with the texture lookup and bias baked in

	virtual int getVideoMemSizeInMB() const;
	virtual void getDisplayAdapterDescription(extStringBuf& description) const;

	virtual HKG_VELOCITYMAP_SUPPORT getVelocityMapSupport();
	virtual bool requiresVelocityMapPass();
	virtual bool beginVelocityMapRender();
	virtual void endVelocityMapRender();
	void prepareVelocityMap();
	void cleanupVelocityMap();
	void displayVelocityMap();

	bool startPostEffects();
	void endPostEffects();

	// debug utils
	void displayShadowMap(int ss);

	void addD3DEventHandler( hkgWindowDX11ResetEventHandler* handler );
	void removeD3DEventHandler( hkgWindowDX11ResetEventHandler* handler );

	virtual bool msaaEnabled() const { return m_msaa; } // MSAA on for RT

	bool getCurrentRTisMultisampled() const { return m_currentRtIsMsaa; }
	void setCurrentRTisMultisampled(bool on);

	ID3D11RenderTargetView* getSceneRenderTargetView( int i, int effectIndex ) const;
	ID3D11ShaderResourceView* getSceneShaderResourceView( int i, int effectIndex ) const; 
	ID3D11ShaderResourceView* getVelocityShaderResourceView( ) const;
	ID3D11ShaderResourceView* getScreenDitherShaderResourceView( ) const;
		
	bool isUsingLinearDepthMap() const { return m_linearDepthMap && m_usingLinearDepthMap; }

	inline const void getDisplayAdapterDesc( DXGI_ADAPTER_DESC& desc ) const;
	inline HKG_DX11_FEATURE_LEVEL getFeatureLevel() const { return m_device? (HKG_DX11_FEATURE_LEVEL)m_device->GetFeatureLevel() : 0;  }

	virtual bool supportsRenderTargetLock() { return true; }
	virtual bool lockCurrentRenderTarget(hkgFrameBufferDesc& desc, hkgFrameBufferRect* lockRect);
	virtual bool unlockCurrentRenderTarget();

	inline int getRenderTargetWidth() const;
	inline int getRenderTargetHeight() const;
	inline DXGI_FORMAT hkgWindowDX11::getRenderTargetFormat() const;

protected:


	hkgWindowDX11();
	virtual ~hkgWindowDX11();
	
    void initShaderCollection();
	void createRenderTargets();
	void releaseRenderTargets();
	bool createNonMSAAColorBuffers();
	bool createMsaaHdrRenderTarget();
	bool createLinearDepthRenderTarget();
	bool createNoiseTextures();

	_D3D11Device*          m_device;
	_D3D11DeviceContext*   m_immediateContext;

#ifdef HKG_DX11_1

	IDXGIAdapter1*			m_adapter;
	IDXGISwapChain1*        m_swapChain;
	DXGI_SWAP_CHAIN_DESC1	m_swapChainDesc;
#else
	
	IDXGIAdapter*			m_adapter;
	IDXGISwapChain*         m_swapChain;
	DXGI_SWAP_CHAIN_DESC	m_swapChainDesc;

#endif

	ID3D11Texture2D*		m_renderTargetBuffer; //AA render target say (from the swap chain)
	ID3D11RenderTargetView* m_renderTargetView; //AA render target say (from the swap chain)

	ID3D11Texture2D*		m_depthStencil;
	ID3D11DepthStencilView*	m_depthStencilView;
	ID3D11ShaderResourceView*	m_depthStencilSRV;

	ID3D11Texture2D*			m_shadowMap[HKG_SHADOWMAP_PSVSM_MAX_NUM_SPLITS + 1];
	ID3D11ShaderResourceView*	m_shadowMapSRView[HKG_SHADOWMAP_PSVSM_MAX_NUM_SPLITS + 1];
	ID3D11RenderTargetView*		m_shadowMapRTView[HKG_SHADOWMAP_PSVSM_MAX_NUM_SPLITS + 1];
	ID3D11SamplerState*			m_shadowMapSamplerState;

	ID3D11Texture2D*			m_shadowMapBlur;
	ID3D11ShaderResourceView*	m_shadowMapBlurSRView;
	ID3D11RenderTargetView*		m_shadowMapBlurRTView;

	bool						m_supportsLinearDepth;
	
	ID3D11Texture2D*			m_linearDepthMapAA;
	ID3D11Texture2D*			m_linearDepthMap; // Non AA
	ID3D11ShaderResourceView*	m_linearDepthMapSRView; // Non AA
	ID3D11RenderTargetView*		m_linearDepthMapRTView; // Non AA
	bool						m_usingLinearDepthMap;
	
	bool						m_supportsColorMap;
	ID3D11Texture2D*			m_sceneColorMap; // Non AA 
	ID3D11ShaderResourceView*	m_sceneColorMapSRView;
	ID3D11RenderTargetView*		m_sceneColorMapRTView;
	
	ID3D11Texture2D*			m_sceneTargetHDR; // MSAA main RT for when PostEffects and HDR both being used
	ID3D11RenderTargetView*		m_sceneTargetHDRRTView;
	
	ID3D11Texture2D*			m_sceneColorMapStaging;

	ID3D11Texture2D*			m_sceneColorTempMap; // Non AA 
	ID3D11ShaderResourceView*	m_sceneColorTempMapSRView;
	ID3D11RenderTargetView*		m_sceneColorTempMapRTView;

	ID3D11Texture2D*		m_shadowMapDepthStencil;
	ID3D11DepthStencilView*	m_shadowMapDSView;

	ID3D11RenderTargetView* m_origRTView[HKG_DX11_NUM_KNOWN_RENDERTARGETS];
	ID3D11DepthStencilView*	m_origDSView;

	bool					m_msaa; 
	int						m_msaaSamples;
	int						m_msaaQuality;
	bool					m_currentRtIsMsaa;

	bool					m_vsync; // VSync / VBlank enabled
	int						m_vsyncInterval;

	int						m_shadowMapSize;
	HKG_SHADOWMAP_QUALITY   m_shadowMapQuality;
	bool					m_shadowMultsampled;
	HKG_SHADOWMAP_SUPPORT   m_shadowMapSupport;
	bool					m_shadowNoClearPass;

	bool					m_haveRunPostEffects;

	HKG_ENABLED_STATE		m_nonShadowState;

	int						m_currentShadowTextureStage;
	mutable float			m_shadowTexMatrix[16];
	mutable float			m_shadowLightMatrix[16];
	mutable bool			m_debugShadowMaps;
	hkgShaderEffect*		m_debugShadowMapShaders;
	hkgShaderEffect*		m_blurShadowMapShaders;
	
	HKG_VELOCITYMAP_SUPPORT m_velocityMapSupport;
	bool						m_usingVelocityMap;
	ID3D11Texture2D*			m_velocityMap; 
	ID3D11ShaderResourceView*	m_velocityMapSRView;
	ID3D11RenderTargetView*		m_velocityMapRTView;
	ID3D11Texture2D*		m_velocityMapDepthStencil; // only needed if msaa on
	ID3D11DepthStencilView*	m_velocityMapDSView;  //
	int m_clearedVelocityMapOnFrameId;

	hkgShaderEffect* m_debugVelocityMapShaders;
	ID3D11SamplerState* m_debugVelocityMapSamplerState;

	mutable ReverseDepthPeelData* m_depthPeelData;

	ID3D11Texture2D*			m_ditherMap; 
	ID3D11ShaderResourceView*	m_ditherMapSRView;
	
	extArray< hkgWindowDX11ResetEventHandler* > m_eventHandlers;

};

#include <Graphics/Dx11/Shared/Window/hkgWindowDX11.inl>

#endif //HK_GRAPHICS_WINDOW_DX11_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
