/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_TEXTURE_DX11_H
#define HK_GRAPHICS_TEXTURE_DX11_H

#include <Graphics/Common/Texture/hkgTexture.h>
#include <Graphics/Common/Texture/hkgCubemapTexture.h>

#include <Graphics/Dx11/Shared/DisplayContext/hkgDisplayContextDX11.h>

class hkgTextureDX11 : public hkgTexture
{
	friend class hkgCubemapTextureDX11;

	public:

		static hkgTexture* createTextureDX11(hkgDisplayContext* context)
		{
			return new hkgTextureDX11(context);
		}	


		virtual bool loadFromFile(const char* filename, void * hinstance);
		virtual bool loadFromDDS(hkIstream& s); 

		virtual bool realize(bool dynamic = false, HKG_TEXTURE_USAGE_HINT useHint = HKG_TEXTURE_USAGE_UNKOWN );	
		virtual void free();		

		virtual HKG_TEXTURE_PIXEL_FORMAT getPixelFormat() const;
		virtual int getRowByteLength(int mipLevel = 0); 
		virtual unsigned char* lock(int mipLevel = 0, bool willWriteAllPixels = false); 
		virtual void unlock(int mipLevel = 0); 
		
		virtual bool updateRegion(int mipLevel, int startX, int startY, int endX, int endY, const unsigned char* data );
		virtual bool supportsUpdateRegion() const HK_OVERRIDE { return true; }

		inline bool isManaged() { return m_bIsManaged; }

		inline ID3D11ShaderResourceView* getSRV() { return m_textureShaderView; }

		/// Reads back the ARGB pixels from an image
		virtual bool readPixels(int x, int y, int w, int h, hkUint32* argbOut) const HK_OVERRIDE;

	protected:
	
		virtual void bind(int stage, HKG_TEXTURE_MODE mode) const;		
		virtual void unbind(int stage) const;		
	
		ID3D11Texture2D*			m_texture;
		ID3D11Texture3D*			m_texture3D;

		ID3D11ShaderResourceView*	m_textureShaderView;
		_D3D11Device*				m_device;

		bool m_bIsManaged;
		unsigned int m_ddsSize;
		bool m_mappedBuffer;

		inline hkgTextureDX11(hkgDisplayContext* context);
		virtual ~hkgTextureDX11();

};


class hkgCubemapTextureDX11 : public hkgCubemapTexture
{
public:

	static hkgCubemapTexture* createCubemapTextureDX11(hkgDisplayContext* context)
	{
		return new hkgCubemapTextureDX11(context);
	}	

	virtual bool loadFromFile(const char* filename, void * hinstance);
	virtual bool loadFromDDS(hkIstream& s); 

	virtual bool realize(bool dynamic = false, HKG_TEXTURE_USAGE_HINT useHint = HKG_TEXTURE_USAGE_UNKOWN );	
	virtual void free();		

	virtual HKG_TEXTURE_PIXEL_FORMAT getPixelFormat() const;
	virtual int getRowByteLength(int mipLevel = 0); 
	virtual unsigned char* lock(int mipLevel = 0, bool willWriteAllPixels = false); 
	virtual void unlock(int mipLevel = 0); 

protected:

	virtual void bind(int stage, HKG_TEXTURE_MODE mode) const;		
	virtual void unbind(int stage) const;		
	
	hkgCubemapTextureDX11(hkgDisplayContext* context);
	virtual ~hkgCubemapTextureDX11();
	
	hkgTextureDX11* m_tex;
};

#include <Graphics/Dx11/Shared/Texture/hkgTextureDX11.inl>

#endif // HK_GRAPHICS_TEXTURE_DX11_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
