/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_BUFFER_DX11_H
#define HK_GRAPHICS_BUFFER_DX11_H

#include <Graphics/Common/Texture/hkgBuffer.h>

// Dx11 implementation of hkgBuffer
class hkgBufferDX11 : public hkgBuffer
{
	public:

		/// Creates a Dx11 graphics buffer
		static hkgBuffer* HK_CALL createBufferDX11(hkgDisplayContext* context);

	public:

		// hkgTexture interface implementation
		bool loadFromFile(const char* filename, void * hinstance) HK_OVERRIDE;
		bool loadFromDDS(hkIstream& s) HK_OVERRIDE;
		HKG_TEXTURE_PIXEL_FORMAT getPixelFormat() const HK_OVERRIDE;
		int getRowByteLength(int mipLevel = 0) HK_OVERRIDE;
		unsigned char* lock(int mipLevel = 0, bool willWriteAllPixels = false) HK_OVERRIDE;
		void unlock(int mipLevel = 0) HK_OVERRIDE;

		bool updateRegion(int mipLevel, int startX, int startY, int endX, int endY, const unsigned char* data );
		virtual bool supportsUpdateRegion() const HK_OVERRIDE { return true; }

		/// Allocates the buffer
		bool realize(bool dynamic = false, HKG_TEXTURE_USAGE_HINT useHint = HKG_TEXTURE_USAGE_UNKOWN );	

		/// Frees the buffer
		void free();		

		/// Returns the shader resource view
		ID3D11ShaderResourceView* getShaderResourceView();

	protected:

		/// Constructor
		hkgBufferDX11(hkgDisplayContext* context);

		/// Destructor
		virtual ~hkgBufferDX11();

		/// Binds the buffer
		void bind(int stage, HKG_TEXTURE_MODE mode) const HK_OVERRIDE;

		/// Unbinds the buffer
		void unbind(int stage) const HK_OVERRIDE;

	protected:

		ID3D11Buffer* m_buffer;
		ID3D11ShaderResourceView* m_bufferShaderView;
		_D3D11Device* m_device;
		bool m_mappedBuffer;
};

#endif	// HK_GRAPHICS_BUFFER_DX11_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
