/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

inline hkgShaderDX11::hkgShaderDX11(HKG_SHADER_TYPE t, hkgDisplayContext* context)
: hkgShader( t ), m_context( static_cast<hkgDisplayContextDX11*>( context ) )
    , m_precompiledShaderReflection(HK_NULL)
#ifdef HKG_DX11_SUPPORT_RUNTIMECOMPILER
    ,m_nativeShaderReflection(HK_NULL)
    ,m_byteCodeBlob(HK_NULL)
#endif
{

}

inline _D3D11Device* hkgShaderDX11::getDevice() const
{ 
	return m_context->getDevice(); 
}

inline const void* hkgShaderDX11::getByteCodePtr() const
{ 
#ifdef HKG_DX11_SUPPORT_RUNTIMECOMPILER
    if (m_byteCodeBlob)
        return m_byteCodeBlob->GetBufferPointer();
#endif
    return m_precompiledShaderReflection? m_precompiledShaderReflection->m_blob.begin() : HK_NULL;
}

inline hkUint32 hkgShaderDX11::getByteCodeSize() const
{ 
#ifdef HKG_DX11_SUPPORT_RUNTIMECOMPILER
    if (m_byteCodeBlob)
        return (hkUint32)m_byteCodeBlob->GetBufferSize();
#endif
    return m_precompiledShaderReflection? m_precompiledShaderReflection->m_blob.getSize() : 0;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
