/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_SHADER_DX11_H
#define HK_GRAPHICS_SHADER_DX11_H

#include <Graphics/Common/Shader/hkgShader.h>
#include <Graphics/Dx11/Shared/DisplayContext/hkgDisplayContextDX11.h>

#include <Graphics/Common/Shader/hkgShaderLibBinary.h>

#ifdef HKG_DX11_SUPPORT_RUNTIMECOMPILER

#ifndef HKG_DX11_METRO_STYLE
#define D3D_INCLUDE_TYPE D3D10_INCLUDE_TYPE
#endif

class hkgShaderDX11InclHandler : public D3D_SHADER_INCLUDE
{
	public:

		hkgShaderDX11InclHandler( const char* inclPath, const char* filename = HK_NULL );
		virtual ~hkgShaderDX11InclHandler() {}

		STDMETHOD(Open)( D3D_INCLUDE_TYPE IncludeType, LPCSTR pFileName, LPCVOID pParentData, LPCVOID *ppData, UINT *pBytes );
		STDMETHOD(Close)( LPCVOID pData );

	protected:

		HRESULT readFile(class hkIstream& s, LPCVOID *ppData, UINT *pBytes);
		extStringPtr m_inclPath;
};

#endif

class hkgShaderDX11 : public hkgShader
{
public:

		/// Direct access to the device etc
	inline _D3D11Device* getDevice() const;

	inline const void* getByteCodePtr() const;
    inline hkUint32 getByteCodeSize() const;

	virtual const char* getDefaultFileNameExtension();

	void setConstantDataRaw( int constBuffer, int byteOffset, void* data, int numBytes);

	bool getInputDesc (const char* name, int& cbuffer, int& byteOffset) const;

	virtual void uploadConstants();

public: // PUBLIC

	virtual void setWKNFloatInputIndex( int i, const float* v, int numV);
	virtual void setFloatInputByName( const char* n, const float* v, int numV );
	
    static void HK_CALL initShaderClasses();
	
protected:		
	
	void setupRefelection();
	
	bool compile(LPCSTR profile, hkIstream& s, const char* entryPoint, const char* includePath,  int numDefines, const ShaderDefine* defines );
	bool compileFromFile(LPCSTR profile, const char* filename, const char* entryPoint, const char* includePath, int numDefines, const ShaderDefine* defines);	
    bool loadFromPrecompiled( hkIstream& s );

	void setupConstantBuffers();
	void updateConstantBuffers();

	inline hkgShaderDX11(HKG_SHADER_TYPE t, hkgDisplayContext* context); 
	virtual ~hkgShaderDX11();

	hkgDisplayContextDX11*  m_context;
	extArray<ID3D11Buffer*>	m_constantBuffers;
	extArray<char*>			m_constantBufferData;
	extArray<hkUint32>		m_constantBufferSize;
	extArray<hkUint32>		m_constantBufferUpdates;

	struct Variable
	{
		hkUint32 constantBufferIndex;
        hkUint32 offset; // in bytes
		hkUint32 size; // in bytes
	};
	extArray<Variable> m_wellKnownVariables;

    hkgShaderReflectedBinaryShader* m_precompiledShaderReflection;

#ifdef HKG_DX11_SUPPORT_RUNTIMECOMPILER
    ID3D11ShaderReflection* m_nativeShaderReflection;
    ID3DBlob*				m_byteCodeBlob;      
#endif

};


#include <Graphics/Dx11/Shared/Shader/hkgShaderDX11.inl>

#endif // HK_GRAPHICS_SHADER_DX11_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
