/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_POST_EFFECT_DX11_H
#define HK_GRAPHICS_POST_EFFECT_DX11_H

#include <Graphics/Common/Shader/hkgPostEffect.h>

#ifndef HKG_DX11_SUPPORTS_EFFECTSLIB
#error You can't include this file on platforms that doesn't either the d3d compiler or d3dx
#endif

#include <Graphics/Dx11/Shared/Shader/EffectsLib/Inc/d3dx11effect.h>

#define HKG_DX11_MAX_EFFECT_RTS 8
class hkgPostEffectDX11 : public hkgPostEffect, public hkgWindowDX11ResetEventHandler
{
public:
		/// Create a blank, platform specific, shader object in the current context as given.
	static hkgPostEffect* createPostEffectDX11(hkgDisplayContext* context)
	{
		return new hkgPostEffectDX11(context);
	}	
	
	//class hkgPostEffect:
	virtual const char* getDefaultFileNameExtension() const { return "fx"; }
	virtual bool realize(hkIstream& istream, int numDefines = 0, const hkgShader::ShaderDefine* defines = HK_NULL);	
	virtual int getNumSceneRenderTargets(); 
	virtual bool requiresVelocityMap();
	virtual void applyPostClear();
	virtual bool applyPostScene(int postEffectIndex);

	virtual void free();	

	virtual void setFloatInputByName( const char* name, const float* v, int numV );

	virtual int  getNumFloatInputs( ) const;
	virtual const char* getFloatInputName( int i ) const;
	virtual int getFloatInputSize( int i ) const; // in num floats
	virtual bool getFloatInputValue( int i, float* v, int maxSize ) const;

	// hkgWindowDX11ResetEventHandler
	virtual void releaseD3D11();
	virtual void resetD3D11();

	virtual bool addTexture( hkgTexture* t, const char* name );
	virtual bool removeTexture( hkgTexture* t );

protected:		
	
	bool createResources();
	void freeResources();

	bool executeScript(ID3DX11EffectPass* pass, const char* str); //DXSAS script
	bool executePostScript(ID3DX11EffectTechnique* t); 
	
	void wipeTargets(ID3D11RenderTargetView** curRTView);

	
	hkgPostEffectDX11(hkgDisplayContext* context);
	virtual ~hkgPostEffectDX11();
			
	bool m_needProjMatrix;
	bool m_needProjInvMatrix;

	ID3D11Device*   m_device;
	ID3DBlob*		m_byteCode;   
	ID3DX11Effect*	m_effect;
	
	ID3DX11EffectVariable* m_viewportParam;
	ID3DX11EffectVariable* m_colorRangeParam;
	ID3DX11EffectVariable* m_sceneColorTextureHandle;
	ID3DX11EffectVariable* m_linearDepthTextureHandle;
	ID3DX11EffectVariable* m_velocityTextureHandle;
	ID3DX11EffectVariable* m_ditherTextureHandle;
	
	ID3D11Buffer* m_drawBuffer;
	ID3D11InputLayout* m_drawBufferInputLayoutPT;

	D3D11_VIEWPORT m_curViewport;
	UINT m_origWidth;
	UINT m_origHeight;

	int m_postEffectIndex;

public: 

	struct TextureMap
	{
		LPCSTR name;
		UINT w;
		UINT h;

		ID3D11Texture2D* texture;
		
		ID3DX11EffectShaderResourceVariable* textureVar;
		
		ID3D11ShaderResourceView* textureSRV; // not null
		ID3D11RenderTargetView*   textureRTV; // may be null
		ID3D11DepthStencilView*	  textureDSV; // may be null

		bool newBind;
		int boundToRTStage; // -1 == none
		int boundToDSStage; // -1 == none
	};

protected:

	TextureMap* findTexture(const char* name);
	TextureMap* findBoundRtTex( int rt );
	TextureMap* findBoundDsTex( );
	void allBound( );

	extArray<TextureMap> m_textures;
	
	struct UserTexture
	{
		extStringPtr name;
		hkgTexture* t;
	};
	extArray< UserTexture > m_userTextures;

	float m_clearColor0[4];
	float m_clearColor1[4];
};

#endif // HK_GRAPHICS_POST_EFFECT_DX11_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
