/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_HULL_SHADER_DX11_H
#define HK_GRAPHICS_HULL_SHADER_DX11_H

#include <Graphics/Dx11/Shared/Shader/hkgShaderDX11.h>

class hkgHullShaderDX11 : public hkgShaderDX11
{
public:
		/// Create a blank, platform specific, shader object in the current context as given.
	static hkgShader* createHullShaderDX11(hkgDisplayContext* context)
	{
		return new hkgHullShaderDX11(context);
	}	
	
		/// Create the platform specific data for the shader. Will compile the shader from the given file.
	virtual bool realize(hkIstream& istream, HKG_SHADER_RENDER_STYLE style);	

	virtual bool realizeCompileFromFile(const char* filename, const char* entryPoint, HKG_SHADER_RENDER_STYLE style, const char* includePath = HK_NULL, int numDefines = 0, const ShaderDefine* defines = HK_NULL);	
	virtual bool realizeCompile( hkIstream& s, const char* entryPoint, HKG_SHADER_RENDER_STYLE style, const char* includePath, int numDefines = 0, const ShaderDefine* defines = HK_NULL);

	inline D3D_PRIMITIVE_TOPOLOGY getTopology() const { return m_topo; }
	inline void setTopology(D3D_PRIMITIVE_TOPOLOGY t) { m_topo = t; }

protected:		
	
	inline hkgHullShaderDX11(hkgDisplayContext* context);
	virtual ~hkgHullShaderDX11();

	virtual bool bind();	
	virtual bool unbind();	
	virtual void free();	

	bool m_bound;
	ID3D11HullShader* m_hullShader;
	D3D_PRIMITIVE_TOPOLOGY m_topo;
};

#include <Graphics/Dx11/Shared/Shader/hkgHullShaderDX11.inl>

#endif //HK_GRAPHICS_HULL_SHADER_DX11_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
