/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2009 Microsoft Corporation.  All Rights Reserved.
//
//  File:       d3dx11dbg.h
//  Content:    D3DX11 debugging functions
//
//////////////////////////////////////////////////////////////////////////////


#ifndef __D3DX11DBG_H__
#define __D3DX11DBG_H__

#ifndef _PREFAST_

#pragma warning( disable: 4068 )

#endif


#include <strsafe.h>
#include <new>

#undef NEW
#undef DELETE

#define NEW new 
#define NEW_PROTO_ARGS size_t s, const std::nothrow_t& t



typedef signed char    INT8;
typedef signed short   INT16;
typedef unsigned char  UINT8;
typedef unsigned short UINT16;


//----------------------------------------------------------------------------
// DPF
//----------------------------------------------------------------------------

#ifdef FXDPF
void cdecl D3DXDebugPrintf(UINT lvl, LPCSTR szFormat, ...);
#define DPF D3DXDebugPrintf
#else // !FXDPF
#pragma warning(disable:4002)
#define DPF() 0
#endif // !FXDPF


//----------------------------------------------------------------------------
// D3DXASSERT
//----------------------------------------------------------------------------

#if _DEBUG
int WINAPI D3DXDebugAssert(LPCSTR szFile, int nLine, LPCSTR szCondition);
#define D3DXASSERT(condition) \
    do { if(!(condition)) D3DXDebugAssert(__FILE__, __LINE__, #condition); } while(0)
#else // !_DEBUG
#define D3DXASSERT(condition) 0
#endif // !_DEBUG



#endif // __D3DX11DBG_H__

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
