/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_FACE_SET_DX11_H
#define HK_GRAPHICS_FACE_SET_DX11_H

#include <Graphics/Common/Geometry/FaceSet/hkgFaceSet.h>
#include <Graphics/Dx11/Shared/DisplayContext/hkgDisplayContextDX11.h>

class hkgFaceSetDX11 : public hkgFaceSet
{
public:

	static hkgFaceSet* createFaceSetDX11(hkgDisplayContext* context)
	{
		return new hkgFaceSetDX11(context);
	}	

	virtual bool supportsLargeIndices() const;

	void render(hkgDisplayContext* context);

	// psuedo Instanced cpu style rendering
	void renderSetState(hkgDisplayContext* state);
	void renderPrims(hkgDisplayContext* state);
	void renderSinglePrim(hkgDisplayContext* state, int pi, hkgBlendMatrixSet* overrideBm );
	void renderCleanState(hkgDisplayContext* state);

	inline _D3D11Device* getDevice();
	inline const _D3D11Device* getDevice() const;

protected:
		
	hkgFaceSetDX11(hkgDisplayContext* context);
	virtual ~hkgFaceSetDX11();

	void createIndexBuffer();

	_D3D11Device*		m_device;
	ID3D11Buffer*		m_indexBuffer;
	bool				m_largeIndices;
	unsigned int		m_numIndices;

public:

	unsigned int			m_numIndexedPrimsThisFrame;

//	struct IndexBufferInfo
//	{
//		unsigned int minIndex;
//		unsigned int startIndex;
//		unsigned int rangeSize;
//	};
//  extArray<IndexBufferInfo> m_connectionInfo;
};

#include <Graphics/Dx11/Shared/Geometry/FaceSet/hkgFaceSetDX11.inl>

#endif // HK_GRAPHICS_FACE_SET_DX11_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
