/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_FONT_DX11_H
#define HK_GRAPHICS_FONT_DX11_H

#include <Graphics/Common/Font/hkgFont.h>


class hkgFontDX11 : public hkgFont
{
public:

	static hkgFont* createFontDX11()
	{
		return new hkgFontDX11;
	}

	virtual void render( hkgDisplayContext* context, const char* text, const float x, const float y, const float color[4] );
	virtual void renderBatch( hkgDisplayContext* context, hkgFont::TextCallback* callback );
	
protected:
	
	struct VertInfo
	{
		float x,y,z;
		float nx,ny,nz;//notused
		float u, v;
		DWORD c;
	};

	virtual void renderTextitem( hkgDisplayContext* context, const hkgFont::TextCallback::TextItem& textItem, VertInfo* verts, int& offset );

protected:

	struct ID3D11Buffer*		m_vertexBuffer;		

	int m_lastUsedIndex;

	extArray<VertInfo> m_vertStorage;

	hkgFontDX11();
	virtual ~hkgFontDX11();

};

#endif // HK_GRAPHICS_FONT_DX11_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
