/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_SKINNED_INSTANCED_DISPLAY_OBJECT_DX11__H
#define HK_GRAPHICS_SKINNED_INSTANCED_DISPLAY_OBJECT_DX11__H

#include <Graphics/Common/DisplayObject/hkgSkinnedInstancedDisplayObject.h>

#include <Graphics/Dx11/Shared/DisplayContext/hkgDisplayContextDX11.h>
#include <Graphics/Dx11/Shared/Window/hkgWindowDX11.h>

class hkgSkinnedInstancedDisplayObjectDX11 : public hkgSkinnedInstancedDisplayObject
{
	public:

		static hkgSkinnedInstancedDisplayObject* HK_CALL createSkinnedInstancedDisplayObjectDX11( hkgDisplayContext* ctx );

		virtual void advanceToFrame(int frameId);
		
			/// special render call to make use of DirectX hardware instancing support in Shader Specification 3.0
		virtual void render( hkgDisplayContext* context ) const;

			/// special picking support. But will intersect with the displayt object transformed BIND pose, not the proper current SKIN POSE.
		virtual int intersect( const hkgRay& ray, bool ignoreBackfaces, hkgDisplayObjectPickData& data) const;

			/// set the total number of instanced objects, must be called BEFORE cloning or rendering ( finalises the VBO )
			/// No need to call if you are going to use replace buffers anyway
		virtual void setMaxNumObjects( int numObjects, int numBonesPerObject = 0, bool allocateBuffers = true, int perBoneUserDateSize = 0 );

		virtual void setRenderMode(HKG_INSTANCED_DISPLAY_MODE mode);
		
			/// adds a shallow copy (shares hkgGeometry down) with the same transform and same flags to m_displayObjects
		virtual hkgDisplayObject* clone( float* transform = HK_NULL );

		virtual void setTransform( const float* transform, int objectIdx );

		virtual const float* getTransform( int objectIdx ) const;

		virtual void setBlendMatrices( int instance, int subFaceSetPrim, hkgBlendMatrixSet* matrices );
		virtual hkgBlendMatrixSet* getBlendMatrices( int instance, int subFaceSetPrim );

		/// Returns the size of the extra per-instance data
		virtual int getExtraInstanceDataSize() const HK_OVERRIDE;

		/// Gets / sets the per-bone user data
		virtual const void* getBoneUserData(int objectIdx, int boneIdx) const;
		virtual void setBoneUserData(int objectIdx, int boneIdx, const void* data);

	protected:

		inline hkgSkinnedInstancedDisplayObjectDX11( hkgDisplayContextDX11* ctx );
		virtual ~hkgSkinnedInstancedDisplayObjectDX11();

		extArray<float> m_cpuTransforms;
		mutable extArray<float> m_prevCpuTransforms;
		hkArray<float> m_cpuInstanceData;

		class hkgWindowDX11* m_ownerWindow;

		extArray< class hkgInstanceMatrices* > m_perInstanceBlendMatrices;
};

#endif // HK_GRAPHICS_SKINNED_INSTANCED_DISPLAY_OBJECT_DX11__H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
