/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#ifndef HK_GRAPHICS_PARTICLE_DISPLAY_OBJECT_DX11__H
#define HK_GRAPHICS_PARTICLE_DISPLAY_OBJECT_DX11__H

#include <Graphics/Common/DisplayObject/hkgParticleDisplayObject.h>
#include <Graphics/Dx11/Shared/DisplayContext/hkgDisplayContextDX11.h>

class hkgVertexShaderDX11;
class hkgGeometryShaderDX11;
class hkgPixelShaderDX11;

class hkgParticleDisplayObjectDX11 : public hkgParticleDisplayObject
{
	public:

		static hkgParticleDisplayObject* HK_CALL createParticleDisplayObjectDX11( hkgDisplayContext* ctx );

		hkgParticleDisplayObjectDX11( hkgDisplayContext* ctx );

		virtual ~hkgParticleDisplayObjectDX11();

		virtual void setMaxNumParticles( int numParticles, bool allocateBuffers = true );
		
		virtual void setPosition( const float* position, int objectIdx );
		virtual const float* getPosition( int objectIdx ) const;

		virtual void setVelocity( const float* vel, int objectIdx );
		virtual const float* getVelocity( int objectIdx ) const;

		virtual void setUserData( const float* data, int objectIdx );
		virtual const float* getUserData( int objectIdx ) const;

		virtual void render(hkgDisplayContext* context) const;

			// If you provide a Texture aswell as a VB, the renderer will assume
			// you want to do ATI style R2B (stream from the texture)
		void setPositionArray( ID3D11Buffer* vb );
		void setVelocityArray( ID3D11Buffer* vb ); 
		void setUserDataArray( ID3D11Buffer* vb ); 
	
		virtual bool sort( bool backToFront, const hkVector4& from );

		/// Particle keyframe
		class ParticleKeyFrame : public hkgDisplayKeyFrame::KeyFrame
		{
			public:

				HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

			public:

				/// Constructor
				ParticleKeyFrame(const hkgDisplayObject* owner)
				:	KeyFrame(owner)
				,	m_positionsOffset(hkUint32(-1))
				,	m_velocitiesOffset(hkUint32(-1))
				,	m_userDataOffset(hkUint32(-1))
				,	m_numParticles(0)
				{}

			protected:

				/// Copy constructor
				ParticleKeyFrame(hkgDisplayKeyFrame& dstKfBuffer, const hkgDisplayKeyFrame& srcKfBuffer, const ParticleKeyFrame& other);

			public:

				/// Clones this keyframe
				virtual KeyFrame* clone(hkgDisplayKeyFrame& dstKfBuffer, const hkgDisplayKeyFrame& srcKfBuffer) const HK_OVERRIDE;

				/// Sets this frame as a linear interpolation of the given frames
				virtual void setInterpolate(const hkgDisplayKeyFrame& kfBufferStart, const KeyFrame* kfStart,
											const hkgDisplayKeyFrame& kfBufferEnd, const KeyFrame* kfEnd,
											hkgDisplayKeyFrame& kfBufferInterp, hkReal interpFactor) HK_OVERRIDE;

			public:

				hkUint32 m_positionsOffset;
				hkUint32 m_velocitiesOffset;
				hkUint32 m_userDataOffset;
				hkUint32 m_numParticles;
		};

		/// Returns the current replay transform info of the display object
		virtual hkgDisplayKeyFrame::KeyFrame* getKeyFrame(hkgDisplayKeyFrame& owner) const HK_OVERRIDE;

		/// Sets the current replay transform info of the display object
		virtual void setKeyFrame(const hkgDisplayKeyFrame& kfBuffer, const hkgDisplayKeyFrame::KeyFrame* keyFrameIn) HK_OVERRIDE;

	protected:

		void renderParticlesPoints( hkgDisplayContext* context, hkgShaderEffect* shaders) const;
		
		_D3D11Device* m_device;

		mutable bool m_cpuPosDirty;
		mutable extArray<hkVector4f> m_cpuPositions;
		mutable bool m_cpuVelDirty;
		mutable extArray<hkVector4f> m_cpuVelocities;
		mutable bool m_cpuUserDirty;
		mutable extArray<hkVector4f> m_cpuUserData;

		bool m_userVBOs;
		ID3D11Buffer* m_buffersVB[3];
		
		extArray<D3D11_INPUT_ELEMENT_DESC> m_posTexDescArray;
		extArray<D3D11_INPUT_ELEMENT_DESC> m_posTexVelDescArray;
};

#endif // HK_GRAPHICS_PARTICLE_DISPLAY_OBJECT_DX11__H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
