/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


inline hkgInstancedDisplayObject* hkgInstancedDisplayObjectDX11::createInstancedDisplayObjectDX11( hkgDisplayContext* ctx )
{
	return new hkgInstancedDisplayObjectDX11( (hkgDisplayContextDX11*)ctx );
}

hkgInstancedDisplayObjectDX11::hkgInstancedDisplayObjectDX11( hkgDisplayContextDX11* ctx )
:	hkgInstancedDisplayObject()
,	m_cpuTransformsDirty(false)
,	m_cpuDataDirty(false)
,	m_device( ctx->getDevice() )
,	m_createdOwnBuffers(false)
,	m_instanceDataBuffer(HK_NULL)
,	m_instanceDataShaderView(HK_NULL)
{
	// disable DX11 hardware instancing
	m_ownerWindow = (hkgWindowDX11*)( ctx->getOwner() );

	m_enableHardwareInstancing = true;
	m_supportsSkinning = true;

	m_curBuffer = 0;
	m_lastUpdatedFrame = 0;
  m_lastTickBuffer = 0;
  m_instanceTransforms[0] = HK_NULL;
	m_instanceTransforms[1] = HK_NULL;

	setStatusFlags( getStatusFlags() | HKG_DISPLAY_OBJECT_DYNAMIC | HKG_DISPLAY_OBJECT_NOT_CULLED | HKG_DISPLAY_OBJECT_USER_AABB);
}

hkgInstancedDisplayObjectDX11::~hkgInstancedDisplayObjectDX11()
{
	DX_SAFE_RELEASE(m_instanceTransforms[0]);
	DX_SAFE_RELEASE(m_instanceTransforms[1]);
	DX_SAFE_RELEASE(m_instanceDataBuffer);
	DX_SAFE_RELEASE(m_instanceDataShaderView);
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
