/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_INSTANCED_DISPLAY_OBJECT_DX11__H
#define HK_GRAPHICS_INSTANCED_DISPLAY_OBJECT_DX11__H

#include <Graphics/Common/DisplayObject/hkgInstancedDisplayObject.h>

#include <Graphics/Dx11/Shared/DisplayContext/hkgDisplayContextDX11.h>
#include <Graphics/Dx11/Shared/Window/hkgWindowDX11.h>

class hkgInstancedDisplayObjectDX11 : public hkgInstancedDisplayObject
{
	public:

		inline static hkgInstancedDisplayObject* HK_CALL createInstancedDisplayObjectDX11( hkgDisplayContext* ctx );

			/// special render call to make use of DirectX hardware instancing support in Shader Specification 3.0
		virtual void render( hkgDisplayContext* context ) const;

			/// special picking support
		virtual int intersect( const hkgRay& ray, bool ignoreBackfaces, hkgDisplayObjectPickData& data) const;

			/// set the total number of instanced objects, must be called BEFORE cloning or rendering ( finalises the VBO )
			/// No need to call if you are going to use replace buffers anyway
		virtual void setMaxNumObjects( int numObjects, int numBonesPerObject = 0, bool allocateBuffers = true, int perBoneUserDataSize = 0 );

		virtual void setRenderMode(HKG_INSTANCED_DISPLAY_MODE mode);
		
      /// Toggle current frame transforms
    virtual void advanceToFrame(int frameId);

			/// adds a shallow copy (shares hkgGeometry down) with the same transform and same flags to m_displayObjects
		virtual hkgDisplayObject* clone( float* transform = HK_NULL );

		virtual void setTransform( const float* transform, int objectIdx );

		virtual void setTransforms( const float* allTransforms, int numTransforms, int startTransform );

		virtual const float* getTransform( int objectIdx ) const;

		/// Sets the bone transform
		virtual void setBoneTransform(const float* transform, int objectIdx, int boneIdx) HK_OVERRIDE;
		virtual void getBoneTransform(int objectIdx, int boneIdx, float* transformOut) const HK_OVERRIDE;

		/// Per bone user data handling
		virtual const void* getBoneUserData(int objectIdx, int boneIdx) const;
		virtual void setBoneUserData(int objectIdx, int boneIdx, const void* data);

			// take the transforms form an externaly created vertex buf source.
			// Will resize m_numObjects etc to suit size of rows.
		void replaceTransformBuffer( ID3D11Buffer* trans );

		inline bool doingHwInstancedRendering() const { return m_instanceTransforms[0] && m_enableHardwareInstancing; }

		/// Returns the size of the extra per-instance data
		virtual int getExtraInstanceDataSize() const HK_OVERRIDE;

		/// Sets the number of active instances
		virtual void setNumObjects(int numObjects) HK_OVERRIDE;

	protected:

		inline hkgInstancedDisplayObjectDX11( hkgDisplayContextDX11* ctx );
		inline virtual ~hkgInstancedDisplayObjectDX11();

		mutable bool m_cpuTransformsDirty;
		mutable bool m_cpuDataDirty;
		extArray<float> m_cpuTransforms;
		hkArray<float> m_cpuInstanceData;

		mutable float m_tempTransform[16];
		
		_D3D11Device* m_device;
		class hkgWindowDX11* m_ownerWindow;

		// an array of floats representing the per instance ( 4 x 4 ) transforms ( gathered from the clones )
		bool m_createdOwnBuffers;
		bool m_enableHardwareInstancing;
    mutable int m_lastUpdatedFrame;
    mutable int m_lastTickBuffer;
		mutable int m_curBuffer;
		mutable ID3D11Buffer* m_instanceTransforms[2]; // 2 for ping pong usuage

		mutable ID3D11Buffer* m_instanceDataBuffer;
		mutable ID3D11ShaderResourceView* m_instanceDataShaderView;
};

#include <Graphics/Dx11/Shared/DisplayObject/hkgInstancedDisplayObjectDX11.inl>

#endif // HK_GRAPHICS_INSTANCED_DISPLAY_OBJECT_DX11__H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
