/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_STATE_MANAGER_DX11_H
#define HK_GRAPHICS_STATE_MANAGER_DX11_H

#include <Graphics/Common/Window/hkgWindow.h>

#define HKG_STATE_MANAGER_MAX_DESC 16
	
class hkgShaderDX11;

class hkgStateManagerDX11 : public hkgReferencedObject
{
	friend hkgDisplayContextDX11;

public:

		/// Get the DX11 Input Layout for a given vertex layout and shader combo
	ID3D11InputLayout* getInputLayout( const D3D11_INPUT_ELEMENT_DESC* vertexLayout, hkUint32 numVertexComponents, hkgShaderDX11* shader );									
	void removeShader( hkgShaderDX11* s );

	/// Get the DX11 Texture sampler state for a give HKG texture state (shared between textures)
	ID3D11SamplerState* getSamplerState( const hkgTexture* texture );
	
	/// State objects
	ID3D11RasterizerState* getRasterState( const HKG_ENABLED_STATE state, const HKG_CULLFACE_MODE cullfaceMode);
	ID3D11DepthStencilState* getDepthStencilState( const HKG_ENABLED_STATE state);
	ID3D11BlendState* getBlendState( const HKG_ENABLED_STATE state, const HKG_BLEND_MODE blendMode, const HKG_ALPHA_SAMPLE_MODE sampleMode );

	// Handy globals
	ID3D11SamplerState* getClampedSampler();

protected:

	hkgStateManagerDX11(hkgDisplayContextDX11* owner);
	virtual ~hkgStateManagerDX11();

	hkgDisplayContextDX11* m_owner;

	struct InputLayouts
	{
		D3D11_INPUT_ELEMENT_DESC m_ed[HKG_STATE_MANAGER_MAX_DESC];
		hkUint32 m_edLen;
		hkgShaderDX11* m_shader;
		ID3D11InputLayout* m_il;
	};

	extArray<InputLayouts> m_inputLayouts;

	extArray<ID3D11SamplerState*> m_textureSamplers;

	extArray<ID3D11RasterizerState*> m_rasterStates;
	extArray<ID3D11DepthStencilState*> m_depthStencilStates;
	extArray<ID3D11BlendState*> m_blendStates;
};

#include <Graphics/Dx11/Shared/DisplayContext/hkgStateManagerDX11.inl>

#endif //HK_GRAPHICS_STATE_MANAGER_DX11_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
