/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_WINDOW_DX11_PC_H
#define HK_GRAPHICS_WINDOW_DX11_PC_H

#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/Dx11/Shared/Window/hkgWindowDX11.h>

class hkgXInputPadPC11;

class hkgWindowDX11PC : public hkgWindowDX11
{
public:

	static hkgWindow* createWindowDX11PC();
	
	virtual bool initialize( HKG_WINDOW_CREATE_FLAG flags, HKG_WINDOW_BUFFERS buffers, int w, int h, const char* name, void* windowHandle = HK_NULL, void* parentHandle = HK_NULL ); // returns success
	virtual bool initializeContext();

	virtual void cleanup();
	
	virtual	bool setAsCurrent(); // only need to call this if you have > 1 window
	virtual bool clearBuffers();
	virtual bool swapBuffers();

	virtual bool updateSize( unsigned int w, unsigned int h);
	virtual bool updatePos( unsigned int x, unsigned int y);

	virtual void setMousePosition(int x,int y);
	virtual void showMouseCursor(bool visible);

	virtual bool setFullscreen(bool on, int x, int y);

	virtual HKG_WINDOW_MSG_STATUS peekMessages(bool inViewportResize = false); // will loop on windows messages if any. Will return if idle.
	virtual void waitMessages(); // block until there is messages

	void setGamePadVibrationState(int i, hkUint16 lowFrequencyStrength, hkUint16 highFrequencyStrength);

	inline HINSTANCE getInstanceHandle() const;

	virtual bool hasGamePads() const { return (getConnectedPads() != HKG_PAD_CONNECTED_NONE); }
	virtual HKG_PAD_CONNECTED_MASK getConnectedPads() const;
		
	inline bool getActiveState() const;
	inline void setActiveState(bool a);
	
	// PUBLIC
	void pollGamePads();

protected:

	hkgWindowDX11PC( HINSTANCE instance, WORD menuID = 0);
	virtual ~hkgWindowDX11PC();

	HRESULT					resizeD3D();
	bool					updateSizeD3D(int w, int h);

	BOOL					m_bUseDepthBuffer;   // Whether to autocreate depthbuffer
    DWORD					m_dwMinDepthBits;    // Minimum number of bits needed in depth buffer
    DWORD					m_dwMinStencilBits;  // Minimum number of bits needed in stencil buffer
 


	HRESULT					toggleFullscreen();
	HRESULT					forceWindowed();
	HRESULT					adjustWindowForChange();

//	HRESULT 				displayErrorMsg( HRESULT hr, DWORD dwType );

    HRESULT					RestoreDeviceObjects();                    
    HRESULT					InvalidateDeviceObjects();

	HINSTANCE				m_hinstance;
	bool					m_ownHWND; // did it create the hwnd?					

	hkgXInputPadPC11*		m_xinputPads[4];
};

// WndProc prototype
LRESULT CALLBACK hkgWindowProcDX11PC(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

#include <Graphics/Dx11/Pc/Window/hkgWindowDX11PC.inl>

#endif //HK_GRAPHICS_WINDOW_DX11_PC_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
