/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */



inline void* hkgWindow::getPlatformHandle() const
{
	return m_platformHandle;
}


inline bool hkgWindow::isFullscreen() const
{
	return m_fullscreen;
}	

inline bool hkgWindow::isWidescreen() const
{
	return m_widescreen;
}	

inline unsigned int hkgWindow::getWidth() const
{
	return m_width;
}

inline unsigned int hkgWindow::getHeight() const
{
	return m_height;
}

inline bool hkgWindow::hasWidescreenAspect() const
{
	//16/9 == 1.7777..   4/3 = 1.3333..
	float aspect = getWidth() / (float)getHeight();
	return (aspect > 1.7f);
}


inline int hkgWindow::getNumViewports() const
{
	return m_viewports.getSize();
}

inline hkgViewport* hkgWindow::getViewport(int i) const
{
	HK_ASSERT(0x1d879a2f,  i < m_viewports.getSize() );
	return m_viewports[i];
}

inline hkgViewport* hkgWindow::getCurrentViewport() const
{
	return m_viewports[m_currentViewport];
}

inline int hkgWindow::getCurrentViewportIndex() const
{
	return m_currentViewport;
}


inline int hkgWindow::getViewportID(hkgViewport* v) const
{
	int i = 0;
	while ( (i< m_viewports.getSize()) && (m_viewports[i] != v) )
		++i;

	if (i != m_viewports.getSize())
		return i;

	return -1;
}

inline hkgViewport* hkgWindow::removeViewport(int i)
{
	HK_ASSERT(0x647bf8f0,  i < m_viewports.getSize() );
	hkgViewport* v = m_viewports[i];
	m_viewports.removeAtAndCopy(i);

	if (m_currentViewport > i)
		--m_currentViewport;
	else if (m_currentViewport == i)
		m_currentViewport = 0;

	return v;
}

inline int hkgWindow::getTVDeadZoneH() const
{
	return m_tvDeadZoneH;
}

inline int hkgWindow::getTVDeadZoneV() const
{
	return m_tvDeadZoneV;
}

inline hkgDisplayContext* hkgWindow::getContext() const
{
	return m_context;
}

inline const hkgViewport* hkgWindow::getWindowOrthoView() const
{
	return m_windowOrthoView;
}

inline hkgViewport* hkgWindow::getWindowOrthoView()
{
	return m_windowOrthoView;
}

inline const hkgMouse& hkgWindow::getMouse() const
{
	return m_mouse;
}

inline void hkgWindow::setMouse(const hkgMouse& value)
{
	m_mouse = value;
}


inline const hkgPad& hkgWindow::getGamePad(int i) const
{
	HK_ASSERT(0x5af001e9,  i < 2 );
	return m_pad[i];
}

inline void hkgWindow::setGamePad(int i, const hkgPad& value)
{
	HK_ASSERT(0x5af001e9,  i < 2 );
	m_pad[i] = value;
}

inline int hkgWindow::getFirstConnectedPadIndex() const
{
	HKG_PAD_CONNECTED_MASK connected = getConnectedPads();
	if ((connected == HKG_PAD_CONNECTED_NONE) || (!getGamePad(0).isConnected()) )// check it isn't just an older hkg renderer always returning pad0 as connected.
		return -1;

	return (connected & HKG_PAD_CONNECTED_0)? 0 : ((connected & HKG_PAD_CONNECTED_1)? 1 : ((connected & HKG_PAD_CONNECTED_2)? 2 : 3));
}

inline const hkgKeyboard& hkgWindow::getKeyboard() const
{
	return m_keyboard;
}

inline void hkgWindow::setKeyboard(const hkgKeyboard& value)
{
	m_keyboard = value;
}

inline void hkgWindow::stepInput()
{
	m_keyboard.cycleState();
	m_mouse.cycleState();
	m_pad[0].cycleState();
	m_pad[1].cycleState();
}

inline void hkgWindow::setKeyFunction( HKG_USER_FUNC_KEY fn, void* userContext )
{
	m_keyFunc = fn;
	m_keyFuncUserContext = userContext;
}

inline void hkgWindow::setMouseMoveFunction( HKG_USER_FUNC_MOUSE_MOVE fn, void* userContext )
{
	m_mouseMoveFunc = fn;
	m_mouseMoveFuncUserContext = userContext;
}

inline void hkgWindow::setMouseWheelFunction( HKG_USER_FUNC_MOUSE_WHEEL fn, void* userContext )
{
	m_mouseWheelFunc = fn;
	m_mouseWheelFuncUserContext = userContext;
}

inline void hkgWindow::setMouseButtonFunction( HKG_USER_FUNC_MOUSE_BUTTON fn, void* userContext )
{
	m_mouseButtonFunc = fn;
	m_mouseButtonFuncUserContext = userContext;
}

inline void hkgWindow::setPadMoveFunction( HKG_USER_FUNC_PAD_MOVE fn, void* userContext )
{
	m_padMoveFunc = fn;
	m_padMoveFuncUserContext = userContext;
}

inline void hkgWindow::setPadButtonFunction( HKG_USER_FUNC_PAD_BUTTON fn, void* userContext )
{
	m_padButtonFunc = fn;
	m_padButtonFuncUserContext = userContext;
}

inline void hkgWindow::setTouchMoveFunction( HKG_USER_FUNC_TOUCH_MOVE fn, void* userContext  )
{
	m_touchMoveFunc = fn;
	m_touchMoveFuncUserContext = userContext;
}

inline void hkgWindow::setTouchStateChangeFunction( HKG_USER_FUNC_TOUCH_STATECHANGE fn, void* userContext )
{
	m_touchStateChangeFunc = fn;
	m_touchStateChangeFuncUserContext = userContext;
}

inline void hkgWindow::setWindowResizeFunction( HKG_USER_FUNC_RESIZE fn, void* userContext )
{
	m_windowResizeFunc = fn;
	m_windowResizeFuncUserContext = userContext;
}

inline void hkgWindow::setWindowCommandFunction( HKG_USER_FUNC_COMMAND fn, void* userContext )
{
	m_windowCommandFunc = fn;
	m_windowCommandFuncUserContext = userContext;
}

inline void hkgWindow::setWindowDropFileFunction( HKG_USER_FUNC_DROPFILE fn, void* userContext )
{
	m_windowDropFileFunc = fn;
	m_windowDropFileFuncUserContext = userContext;
}

inline void hkgWindow::setWindowAccelerometerFunction( HKG_USER_FUNC_ACCELEROMETER fn, void* userContext )
{
	m_windowAccelerometerFunc = fn;
	m_windowAccelerometerFuncUserContext = userContext;
}
	
	
inline bool hkgWindow::hasWindowDropFileFunction() const
{
	return m_windowDropFileFunc != HK_NULL;
}

inline void hkgWindow::handleFileDrop( const char* filename, int x, int y) const
{
	if (m_windowDropFileFunc)
	{
		m_windowDropFileFunc(this, x, y, filename, m_windowDropFileFuncUserContext);
	}
}


inline void hkgWindow::setWantViewportBorders(bool on)
{
	m_viewportBorders = on;
}

inline bool hkgWindow::getWantViewportBorders() const
{
	return m_viewportBorders;
}

inline void hkgWindow::setWantViewportThickGrayBorders(bool on)
{
	m_viewportThickGrayBorders = on;
}

inline void hkgWindow::setWantViewportResizeByMouse(bool on)
{
	m_viewportResizeByMouse = on;
}


inline void hkgWindow::setClearColor( const float c[3] )
{
	hkgVec3Copy( m_clearColor, c );
}

inline void hkgWindow::getClearColor( float c[3]) const
{
	hkgVec3Copy( c, m_clearColor);
}

inline float* hkgWindow::getClearColorPtr()
{
	return m_clearColor;
}

inline void hkgWindow::setWantDrawMousePointer(bool on)
{
	m_drawMousePointer = on;
}

inline bool hkgWindow::getWantDrawMousePointer() const
{
	return m_drawMousePointer;
}

inline void hkgWindow::setWantDrawHavokLogo(bool on)
{
	m_drawHavokLogo = on;
}

inline bool hkgWindow::getWantDrawHavokLogo() const
{
	return m_drawHavokLogo;
}


inline void hkgWindow::setWantVirtualMouse(bool on)
{
	m_virtualMouseEnabled = on;
}

inline bool hkgWindow::getWantVirtualMouse() const
{
	return m_virtualMouseEnabled;
}

inline void hkgWindow::setUseVirtualGamePad(bool on, bool hidden)
{
	m_useVirtualGamepad = on;
	m_virtualGamepadHidden = hidden;
}

inline bool hkgWindow::getUseVirtualGamePad() const
{
	return m_useVirtualGamepad;
}

inline bool hkgWindow::getVirtualGamePadHidden() const
{
	return m_virtualGamepadHidden;
}

inline void hkgWindow::setMouseIsTouchEvent(bool on)
{
	m_mouseIsTouchEvent = on;
}

inline bool hkgWindow::getMouseIsTouchEvent() const
{
	return m_mouseIsTouchEvent;
}


inline void hkgWindow::setVirtualMousePos(int x, int y)
{
	m_virtualMousePos[0] = x;
	m_virtualMousePos[1] = y;
}

inline void hkgWindow::setPadHasIndependentAnalogTriggers( short pad, hkBool hasIndependentTriggers )
{
	m_pad[pad].m_hasIndependentAnalogTriggers = hasIndependentTriggers;
}

inline void hkgWindow::toggleCurrentStereoTargetEye()
{
	HKG_STEREO_MODE m = getCurrentStereoMode();
	if (m == HKG_STEREO_LEFT_EYE)
	{
		setCurrentStereoMode(HKG_STEREO_RIGHT_EYE);
	}
	else if (m == HKG_STEREO_RIGHT_EYE)
	{
		setCurrentStereoMode(HKG_STEREO_LEFT_EYE);
	}
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
