/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_TEXTURE_DEFINES__H
#define HK_GRAPHICS_TEXTURE_DEFINES__H

typedef unsigned short HKG_TEXTURE_DEFAULTS;
#define HKG_TEXTURE_HAVOKLOGO	1
#define HKG_TEXTURE_FONT		2
#define HKG_TEXTURE_POINTER		3	
#define HKG_TEXTURE_CHECKER		4
#define HKG_TEXTURE_PERLINNOISE	5
#define HKG_TEXTURE_DIAGONAL	6
#define HKG_TEXTURE_FONT_THICK	7
#define HKG_TEXTURE_VIRTUAL_GAMEPAD 8
#define HKG_TEXTURE_VIRTUAL_GAMEPAD_DRAWER_HANDLE 9
#define HKG_TEXTURE_VIRTUAL_ANALOGSTICK 16

typedef unsigned short HKG_TEXTURE_PIXEL_FORMAT;
#define HKG_TEXTURE_PIXEL_RGB      1
#define HKG_TEXTURE_PIXEL_RGBA     2
#define HKG_TEXTURE_PIXEL_BGR      3
#define HKG_TEXTURE_PIXEL_BGRA     4
#define HKG_TEXTURE_PIXEL_ARGB     5
#define HKG_TEXTURE_PIXEL_ABGR     6
#define HKG_TEXTURE_PIXEL_L		   7
#define HKG_TEXTURE_PIXEL_LA	   8
#define HKG_TEXTURE_PIXEL_RG	   9
#define HKG_TEXTURE_PIXEL_UNKNOWN  10
#define HKG_TEXTURE_PIXEL_SWIZZLED 16 // can be combined with any of the above formats. It means it is not a linear internal format.

typedef unsigned short HKG_TEXTURE_COORDINATE_SPACE;
#define HKG_TEXTURE_00_UPPER_LEFT (1)
#define HKG_TEXTURE_00_LOWER_LEFT (1<<1)

typedef unsigned short HKG_TEXTURE_UVMODE;
#define HKG_TEXTURE_CLAMP	1
#define HKG_TEXTURE_WRAP	2

typedef unsigned short HKG_TEXTURE_TYPE;
#define HKG_TEXTURE_SINGLE	1
#define HKG_TEXTURE_CUBEMAP 2
#define HKG_TEXTURE_BUFFER  3

typedef unsigned short HKG_TEXTURE_COORD_GEN;
#define HKG_TEXTURE_COORDGEN_NONE 0
#define HKG_TEXTURE_COORDGEN_CSNORMAL 1  // camera space normal
#define HKG_TEXTURE_COORDGEN_CSPOS    2  // camera space pos
#define HKG_TEXTURE_COORDGEN_CSREFLECTION  3 // camera space reflection

typedef unsigned short HKG_TEXTURE_FILTER;
#define HKG_TEXTURE_FILTER_POINT	   1
#define HKG_TEXTURE_FILTER_LINEAR      2
#define HKG_TEXTURE_FILTER_ANISOTROPIC 3

typedef unsigned short HKG_TEXTURE_USAGE_HINT;
#define HKG_TEXTURE_USAGE_UNKOWN		1
#define HKG_TEXTURE_USAGE_CUBEMAP		2
#define HKG_TEXTURE_USAGE_VOLUME		4
#define HKG_TEXTURE_USAGE_HDR    		8		// Make sure it is loaded in a HDR format (16F say)
#define HKG_TEXTURE_USAGE_RGB_TO_SRGB	16		// Convert to sRGB
#define HKG_TEXTURE_USAGE_IS_SRGB		32		// Is sRGB already
#define HKG_TEXTURE_USAGE_DATA_BUFFER	64		// Is a buffer containing generic data


typedef unsigned int HKG_DDS_FORMAT_TYPE;
#define HKG_TEXTURE_DDS_COMPRESSED_RGBA_DXT1 1
#define HKG_TEXTURE_DDS_COMPRESSED_RGB_DXT1  2
#define HKG_TEXTURE_DDS_COMPRESSED_RGBA_DXT3 3
#define HKG_TEXTURE_DDS_COMPRESSED_RGBA_DXT5 4
#define HKG_TEXTURE_DDS_L                    5
#define HKG_TEXTURE_DDS_LA                   6
#define HKG_TEXTURE_DDS_RG                   7
#define HKG_TEXTURE_DDS_RGBA                 8
#define HKG_TEXTURE_DDS_RGB                  9
#define HKG_TEXTURE_DDS_BGRA                 10
#define HKG_TEXTURE_DDS_BGR                  11
#define HKG_TEXTURE_DDS_UNSIGNED_BYTE        12
#define HKG_TEXTURE_DDS_UNSIGNED_SHORT565    13
#define HKG_TEXTURE_DDS_UNSIGNED_SHORT1555   14
#define HKG_TEXTURE_DDS_RGB565               15
#define HKG_TEXTURE_DDS_RGBA1555             16
#define HKG_TEXTURE_DDS_FLOAT32				 17
#define HKG_TEXTURE_DDS_FLOAT16				 18

typedef unsigned short HKG_TEXTURE_TYPE_HINT;
#define HKG_TEXTURE_TYPE_UNKNOWN	0
#define HKG_TEXTURE_TYPE_DIFFUSE	1
#define HKG_TEXTURE_TYPE_REFLECTION	2
#define HKG_TEXTURE_TYPE_BUMP		3
#define HKG_TEXTURE_TYPE_NORMAL		4
#define HKG_TEXTURE_TYPE_DISPLACEMENT 5
#define HKG_TEXTURE_TYPE_SPECULAR	6
#define HKG_TEXTURE_TYPE_SPECULARANDGLOSS 7
#define HKG_TEXTURE_TYPE_OPACITY	8
#define HKG_TEXTURE_TYPE_EMISSIVE	9
#define HKG_TEXTURE_TYPE_REFRACTION	10
#define HKG_TEXTURE_TYPE_GLOSS		11
#define HKG_TEXTURE_TYPE_MASK		12
#define HKG_TEXTURE_TYPE_BLEND		13
#define HKG_TEXTURE_TYPE_DOMINANTS	14
#define HKG_TEXTURE_NUM_TYPES   15

// Extra internal types
#define HKG_TEXTURE_TYPE_VSM			14
#define HKG_TEXTURE_TYPE_DIM			15
#define HKG_TEXTURE_TYPE_SIM			16
#define HKG_TEXTURE_TYPE_NORMALDISPLACE 17


typedef unsigned short HKG_TEXTURE_BIND_FLAGS;
#define HKG_TEXTURE_BIND_VS			1
#define HKG_TEXTURE_BIND_PS			2
#define HKG_TEXTURE_BIND_GS			4
#define HKG_TEXTURE_BIND_HS			8
#define HKG_TEXTURE_BIND_DS			16

#endif //HK_GRAPHICS_TEXTURE_DEFINES__H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
