/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

const hkgTexture* hkgSkyBox::getTexture(HKG_SKYBOX_TEXTURE f) const
{
	int index = f;
	if (f >= HKG_SKYBOX_TEXTURE_CUBE) 
	{
		if (m_cubeMapTexture)
			index -= HKG_SKYBOX_TEXTURE_CUBE;
		else
			return HK_NULL;
	}
	return m_textures[index];
}

hkgTexture* hkgSkyBox::getTexture(HKG_SKYBOX_TEXTURE f)
{
	int index = f;
	if (f >= HKG_SKYBOX_TEXTURE_CUBE) 
	{
		if (m_cubeMapTexture)
			index -= HKG_SKYBOX_TEXTURE_CUBE;
		else
			return HK_NULL;
	}
	return m_textures[index];
}

void hkgSkyBox::setTexture(HKG_SKYBOX_TEXTURE f, hkgTexture* t, hkColor::Argb color)
{
	if (t) t->reference();
	int index = f;
	if (f >= HKG_SKYBOX_TEXTURE_CUBE) 
	{
		index -= HKG_SKYBOX_TEXTURE_CUBE;
		m_cubeMapTexture = true;
	}
	else
	{
		HK_ASSERT(0x0, !m_cubeMapTexture);
	}

	if (m_textures[index]) m_textures[index]->release();
	m_textures[index] = t;
	m_colors[index] = color;
}

inline const float* hkgSkyBox::getTransformPtr() const
{
	return m_transform;
}

inline const float* hkgSkyBox::getTransformInvPtr() const
{
	return m_transformInv;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
