/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_SKYBOX_H
#define HK_GRAPHICS_SKYBOX_H

#include <Common/Base/Types/hkBaseTypes.h>
#include <Graphics/Common/Texture/hkgTexture.h>
#include <Graphics/Common/Texture/SkyBox/hkgSkyBoxDefines.h>


class hkgSkyBox : public hkgReferencedObject
{
	public:
			/// Create a platform specific sky box object.
		static hkgSkyBox* (HK_CALL *create)();

			/// Default create function, use ::create instead.
		static hkgSkyBox* defaultCreateInternal();

			/// Set the textures to be used by the sky box.
			/// Optional as they can be solid color sometimes, use (null,color) then.
			/// To never draw a face, use (null, 0x00******) as alpha is not allowed. 
		inline void setTexture(HKG_SKYBOX_TEXTURE f, hkgTexture* t, hkColor::Argb color); 
		inline const hkgTexture* getTexture(HKG_SKYBOX_TEXTURE f) const;
		inline hkgTexture* getTexture(HKG_SKYBOX_TEXTURE f);
		
		// Setting just 'Up' will assume rotation
		void setUp(const float* up);

		// set the full transform for the env
		void setTransform(const float* t);
		inline const float* getTransformPtr() const;
		inline const float* getTransformInvPtr() const;

		void render( class hkgDisplayContext* context, class hkgCamera* camera);

	protected:

		hkgSkyBox();
		virtual ~hkgSkyBox();

		hkBool			m_cubeMapTexture;
		hkgTexture*		m_textures[6];
		hkColor::Argb  m_colors[6];

		float			m_transform[16];
		float			m_transformInv[16];
};

#include <Graphics/Common/Texture/SkyBox/hkgSkyBox.inl>

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
