/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_BRIDGE_SHADER_LIB_BINARY_H
#define HK_GRAPHICS_BRIDGE_SHADER_LIB_BINARY_H

// Serializable set of binary (precompiled) shaders
class hkgShaderLibBinary : public hkReferencedObject
{
public:

	HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DISPLAY );
	HK_DECLARE_REFLECTION();

	hkgShaderLibBinary() {}
	virtual ~hkgShaderLibBinary() {}


	// Note we don't use extString etc here, so this shader lib can show up 
	// in the main Havok mem stats

	hkStringPtr m_platform;				// PC 
	hkStringPtr m_rendererSubsystem;	// OpenGL
	hkStringPtr m_rendererLanguage;		// Cg

	struct BinaryShader
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DISPLAY, hkgShaderLibBinary::BinaryShader );
		HK_DECLARE_REFLECTION();

		enum ShaderType
		{
			Vertex = 0,
			Hull = 1,
			Domain = 2,
			Geometry = 3,
			Pixel = 4,
			NumTypes = 5,
		};

		enum ProgramType
		{
			VS_FLAG	= (1 << Vertex),
			HS_FLAG	= (1 << Hull),
			DS_FLAG	= (1 << Domain),
			GS_FLAG	= (1 << Geometry),
			PS_FLAG	= (1 << Pixel),

			VsPs		= (VS_FLAG | PS_FLAG),									// Vertex -> Pixel
			VsGsPs		= (VS_FLAG | GS_FLAG | PS_FLAG),						// Vertex -> Geometry -> Pixel
			VsHsDsPs	= (VS_FLAG | HS_FLAG | DS_FLAG | PS_FLAG),				// Vertex -> Hull -> Domain -> Pixel
			VsHsDsGsPs	= (VS_FLAG | HS_FLAG | DS_FLAG | GS_FLAG | PS_FLAG),	// Vertex -> Hull -> Domain -> Geometry-> Pixel
		};

			/// Serialization constructor
		BinaryShader(class hkFinishLoadedObjectFlag flag)
		:	m_name(flag)
		,	m_uniqueName(flag)
		,	m_blob(flag)
		{}
		BinaryShader() {}

		BinaryShader( const BinaryShader& other )
			: m_type(other.m_type),
			  m_name(other.m_name),
			  m_uniqueName(other.m_uniqueName),
			  m_profileMajorVer(other.m_profileMajorVer),
			  m_profileMinorVer(other.m_profileMinorVer)
		{   
			// for this object to be usable in arrays, it needs to be copy constructible
			m_blob.append(other.m_blob);
		}

		hkEnum<ShaderType, hkUint8> m_type;
		hkStringPtr m_name; // entrypoint 
		hkStringPtr m_uniqueName; // orig filename + entrypoint + defines
		hkUint32 m_profileMajorVer; 
		hkUint32 m_profileMinorVer;
		hkArray<hkUint8> m_blob; // assumes blob has enough info for register<->name lookup etc. May be a hkgShaderReflectedBinaryShader on some platforms
	};

	hkArray< struct BinaryShader > m_shaders;

	struct Program
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DISPLAY, hkgShaderLibBinary::Program );
		HK_DECLARE_REFLECTION();

			/// Serialization constructor
		Program(class hkFinishLoadedObjectFlag flag)
		:	m_shaders(flag)
		,	m_style(flag)
		{}
		Program() {}

		Program( const Program& other )
			: m_style(other.m_style)
		{
			// for this object to be usable in arrays, it needs to be copy constructible
			m_shaders.append(other.m_shaders);
		}

		hkArray< hkInt32 > m_shaders; // index into main list
		hkStringPtr m_style;
	};
	
	hkArray< struct Program > m_programs;

public:
	hkgShaderLibBinary(hkFinishLoadedObjectFlag f) : hkReferencedObject(f), m_shaders(f), m_programs(f) { }

};

// Used if runtime not able to reflect the bin blob by itself
class hkgShaderReflection : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DISPLAY );
    HK_DECLARE_REFLECTION();

    hkgShaderReflection() {}

    struct Variable
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DISPLAY, hkgShaderReflection::Variable );
        HK_DECLARE_REFLECTION();
        Variable(class hkFinishLoadedObjectFlag flag)
            :	m_name(flag)
        {}
        Variable() {}

        hkUint32 m_size; // in bytes
        hkUint32 m_startOffset; // in bytes, from start of cb
        hkStringPtr m_name;
        // xx type etc, usually infered from use at runtime etc
    };

    struct ResourceBinding
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DISPLAY, hkgShaderReflection::ResourceBinding );
        HK_DECLARE_REFLECTION();
        ResourceBinding(class hkFinishLoadedObjectFlag flag)
            :	m_name(flag)
        {}
        ResourceBinding() {}

        hkStringPtr m_name;
        hkUint32 m_bindPoint; // sampler index
        // xx type etc,
    };

    struct ConstantBuffer
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DISPLAY, hkgShaderReflection::ConstantBuffer );
        HK_DECLARE_REFLECTION();

        ConstantBuffer(class hkFinishLoadedObjectFlag flag)
            :	m_name(flag), m_variables(flag)
        {}
        ConstantBuffer() {}

        hkUint32 m_size; // in bytes
        hkStringPtr m_name; // if has one
        hkArray< Variable > m_variables;
    };

    hkArray< ConstantBuffer > m_buffers;
    hkArray< ResourceBinding > m_resources;

public:
    hkgShaderReflection(hkFinishLoadedObjectFlag f) : hkReferencedObject(f), m_buffers(f), m_resources(f) { }

};

class hkgShaderReflectedBinaryShader : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DISPLAY );
    HK_DECLARE_REFLECTION();

    hkgShaderReflectedBinaryShader() {} 
    hkgShaderReflection m_refection;
    hkArray<hkUint8> m_blob; // blob for platform 

public:
    hkgShaderReflectedBinaryShader(hkFinishLoadedObjectFlag f) : hkReferencedObject(f), m_refection(f), m_blob(f) { }


};

#endif //HK_GRAPHICS_BRIDGE_SHADER_LIB_BINARY_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
