/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_SHADER_LIB_H
#define HK_GRAPHICS_SHADER_LIB_H

class hkgDisplayContext;
class hkgShader;
class hkgShaderEffectCollection;
class hkgShaderLibBinary;
class hkResource;
class hkgMaterial;

#include <Graphics/Common/Texture/hkgTexture.h>
#include <Graphics/Common/Shader/hkgShaderLibDefines.h>

// The shader files used by this lib have comments near the top in the form:   
 ///:STYLE <vertexentryname> <hullentryname> <domainentryname> <geometryentryname> <pixelentryname> L<type><maxnum> T<numtcoords> {SHADOWMAP,DIFFUSEn,REFLECTION,BUMPn,NORMALn,DISPLACEMENTn,SPECULARn,SPECULARANDGLOSSn,OPACITYn,EMISSIVEn,REFRACTION,GLOSSn} {INSTANCED,SKINNED}
// where the texture type is ordered as per enum in hkxMaterial so agreeded final stage slot between hkx and hkg
// and where 'n' is the tcoord channel that will be used for that tex type so we can match exactly
// and where light type is D for Directional, O for Omni, S for Spot, and maxnum is the max num lights used (assumes used numLights constant to render with less).
// When you have a hkxMaterial (self describing) or demo material you would like a shader for
// on the current platform, then you can request one from this lib
// It will cache shaders and resuse etc as requested.
class hkgShaderLib : public hkgReferencedObject
{
	public:

		// Shader types
		enum ShaderType
		{
			SHADER_TYPE_VERTEX		= 0,
			SHADER_TYPE_HULL		= 1,
			SHADER_TYPE_DOMAIN		= 2,
			SHADER_TYPE_GEOMETRY	= 3,
			SHADER_TYPE_PIXEL		= 4,
			NUM_SHADER_TYPES		= 5,
		};

	public:

		// Constructor
		hkgShaderLib( hkgDisplayContext* ctx );

		// Destructor
		virtual ~hkgShaderLib( );

	public:

		/// shaders can be slow to compile at runtime. Turn this on to use precompiled versions always on PC etc
		void preferPrecompiledShaders(bool enabled);

			// Add a search path to find the shaders (.hlsl and .cg files)
			// eg  ./resources/shaders
		void addSearchPath( const char* path );
		void clearSearchPaths();

		// force next search to not use precompiled shaders
		void clearCache();

		// usually we auyto load normal and instanced shaders
		// use this method to toggle
		void setAutoLoadShaderTypes( bool instanced, bool skinned, bool depthPeel = false );
		void getAutoLoadShaderTypes( bool& instanced, bool& skinned, bool& depthPeel );

		void setIrradianceMapLighting( bool on);
		bool getIrradianceMapLighting( ) const;

		// Set to -1 to just use current platform default (say 64)
		// It will not allow it to exceed platform max (64 in SM2/SM3, 1024 in SM4 etc)
		void setMaxBlendMatrices(int m);
		int getMaxBlendMatrices() const;
		
		struct TextureStage
		{
			TextureStage() { }
			TextureStage( HKG_TEXTURE_TYPE_HINT t, int c) : m_type(t), m_textureCoord(c) { }
			HKG_TEXTURE_TYPE_HINT m_type; // Diffuse, Normal, etc
			int m_textureCoord; // Texcoord channel used
		};


		void findUsedTextureStages(const hkgMaterial* m, extArray<TextureStage>& materialStages);

			/// Get a shader collection for the given material
			/// Will normal give back at least 3 sets (2 for shadow map passes, and 1 for no shadows) 
			/// Will return NULL if none found that match
			/// Pass 0 for numLights for unlit shaders
		hkgShaderEffectCollection* findShader( const extArray<TextureStage>& sourceMaterialStages, HKG_SHADERLIB_OBJECT_FLAGS objectFlags = HKG_SHADERLIB_OBJECT_NO_FLAGS, 
			HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints = HKG_SHADERLIB_EXTRA_TEXTURE_HINT_NONE, int numLights = 1, const char* debugName = HK_NULL /*for error reporting only*/, int numTCoordsHint = -1);

		hkgShaderEffectCollection* findShader( HKG_SHADERLIB_WELLKNOWN_TYPE t, HKG_SHADERLIB_OBJECT_FLAGS objectFlags = HKG_SHADERLIB_OBJECT_NO_FLAGS, 
			HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints = HKG_SHADERLIB_EXTRA_TEXTURE_HINT_NONE, int numLights = 1);

		/// Add the depth and velocity pass shaders etc to the given shader effect
		void addDefaultPassShaders( hkgShaderEffectCollection* addTo, HKG_SHADERLIB_OBJECT_FLAGS objectStyle, HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints );


	public:

		class ShaderMatcher
		{
		public:
			virtual ~ShaderMatcher() {}

			virtual bool styleMatch(	const char* shaderFileStyle, HKG_SHADERLIB_OBJECT_FLAGS objectFlags, HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints, int numLights, int numTCoordsHint,
										bool supportsDepthPeel, bool supportsDisplacementMaps, bool supportIrradianceMaps ) const = 0;
		};

	protected:

		hkgShaderEffectCollection* findShaderMatch( const ShaderMatcher& matchFunc, HKG_SHADERLIB_OBJECT_FLAGS objectFlags, HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints, int numLights, int numTCoordsHint );
	    hkgShaderEffectCollection* findShaderBinMatch( const ShaderMatcher& matchFunc, HKG_SHADERLIB_OBJECT_FLAGS objectFlags, HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints, int numLights, int numTCoordsHint );
		
		hkgShaderEffectCollection* createUberShader( const extArray<TextureStage>& sourceMaterialStages, HKG_SHADERLIB_OBJECT_FLAGS objectFlags = HKG_SHADERLIB_OBJECT_NO_FLAGS, 
			HKG_SHADERLIB_EXTRA_TEXTURE_HINTS textureHints = HKG_SHADERLIB_EXTRA_TEXTURE_HINT_NONE, int numLights = 1, const char* debugName = HK_NULL /*for error reporting only*/, int numTCoordsHint = -1 );

		void createDepthShaders();
	    void createDepthBinShaders();
		void createVelocityShaders();
        void findShaderBin();

		hkgDisplayContext* m_context;

		extArray< extStringPtr > m_searchPaths;
		extArray< struct ShaderCacheInfo* > m_shaderCache; // shader pairs already created
		
		bool m_autoLoadInstanced;
		bool m_autoLoadSkinned;
		bool m_autoLoadDepthPeel;
		bool m_usingIrradianceMaps;


		int m_maxBlendMatrices;

		bool	   m_lookedForDepthShaders;
		hkgShader* m_toDepthVShader;
		hkgShader* m_toDepthVShaderInstanced;
		hkgShader* m_toDepthVShaderInstancedSkinned;
		hkgShader* m_toDepthVShaderInstancedRigidSkinned;
		hkgShader* m_toDepthVShaderSkinned;
		hkgShader* m_toDepthVShaderRigidSkinned;
		hkgShader* m_toDepthPShader;
		hkgShader* m_toDepthPShaderAlphaDiscard;

#ifdef HK_PLATFORM_WIIU
		hkgShader* m_toDepthPShaderSkinned;
		hkgShader* m_toDepthPShaderRigidSkinned;
		hkgShader* m_toDepthPShaderInstanced;
		hkgShader* m_toDepthPShaderInstancedSkinned;
		hkgShader* m_toDepthPShaderInstancedRigidSkinned;
#endif

		bool	   m_lookedForVelShaders;
		hkgShader* m_toVelocityVShader;
		hkgShader* m_toVelocityVShaderDynamicVB;
		hkgShader* m_toVelocityVShaderInstanced;
		hkgShader* m_toVelocityVShaderSkinned;
		hkgShader* m_toVelocityPShader;
		hkgShader* m_toVelocityPShaderAlphaDiscard;

		hkResource* m_binaryShaderLibFile;
		hkgShaderLibBinary* m_binaryShaderLib;
		hkArray<hkgShader*> m_binaryShaders; 
		hkArray<hkgShaderEffectCollection*> m_binaryShaderCollections; 

		bool m_checkedForShaderBin;
		bool m_preferPrecompiled;
};

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
